/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.objectweb.howl.log.LogConfigurationException;

public class Configuration {
    private boolean listConfig = false;
    private boolean checksumEnabled = true;
    private int bufferSize = 4096;
    private String bufferClassName = "org.objectweb.howl.log.BlockLogBuffer";
    private int maxBuffers = 0;
    private int minBuffers = 4;
    private int flushSleepTime = 50;
    private int threadsWaitingForceThreshold = Integer.MAX_VALUE;
    int maxBlocksPerFile = Integer.MAX_VALUE;
    int maxLogFiles = 2;
    String logFileDir = "../logs";
    String logFileExt = "log";
    String logFileName = "logger";

    public Configuration() {
    }

    public Configuration(Properties prop) throws LogConfigurationException {
        this();
        this.parseProperties(prop);
    }

    public Configuration(File propertyFile) throws LogConfigurationException {
        this();
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(propertyFile));
            this.parseProperties(prop);
        }
        catch (FileNotFoundException e) {
            throw new LogConfigurationException(e.toString());
        }
        catch (IOException e) {
            throw new LogConfigurationException(e.toString());
        }
    }

    private void showConfig(String key, String val) {
        if (this.listConfig) {
            System.err.println(key + ": " + val);
        }
    }

    private void showConfig(String key, int val) {
        if (this.listConfig) {
            System.err.println(key + ": " + val);
        }
    }

    private void showConfig(String key, boolean val) {
        if (this.listConfig) {
            System.err.println(key + ": " + val);
        }
    }

    private void parseProperties(Properties prop) throws LogConfigurationException {
        String val = null;
        String key = null;
        key = "listConfig";
        val = prop.getProperty("listConfig", "true").toLowerCase();
        this.listConfig = val.equals("true");
        this.showConfig(key, this.listConfig);
        key = "bufferClassName";
        this.bufferClassName = prop.getProperty("bufferClassName", this.bufferClassName);
        this.showConfig("bufferClassName", this.bufferClassName);
        key = "bufferSize";
        val = prop.getProperty("bufferSize");
        if (val != null) {
            int ival = Integer.parseInt(val);
            if (ival > 1024) {
                ival = (ival + 512) / 1024;
            }
            this.bufferSize = ival * 1024;
        }
        this.showConfig(key, this.bufferSize);
        key = "checksumEnabled";
        val = prop.getProperty("checksumEnabled", "true").toLowerCase();
        this.checksumEnabled = val.equals("true");
        this.showConfig(key, this.checksumEnabled);
        key = "flushSleepTime";
        val = prop.getProperty("flushSleepTime");
        if (val != null) {
            this.flushSleepTime = Integer.parseInt(val);
        }
        this.showConfig(key, this.flushSleepTime);
        key = "logFileDir";
        this.logFileDir = prop.getProperty("logFileDir", this.logFileDir);
        this.showConfig(key, this.logFileDir);
        key = "logFileExt";
        this.logFileExt = prop.getProperty("logFileExt", this.logFileExt);
        this.showConfig(key, this.logFileExt);
        key = "logFileName";
        this.logFileName = prop.getProperty("logFileName", this.logFileName);
        this.showConfig(key, this.logFileName);
        key = "maxBlocksPerFile";
        val = prop.getProperty("maxBlocksPerFile");
        if (val != null) {
            this.maxBlocksPerFile = Integer.parseInt(val);
        }
        this.showConfig(key, this.maxBlocksPerFile);
        key = "minBuffers";
        val = prop.getProperty("minBuffers");
        if (val != null) {
            this.minBuffers = Integer.parseInt(val);
        }
        this.showConfig(key, this.minBuffers);
        key = "maxBuffers";
        val = prop.getProperty("maxBuffers");
        if (val != null) {
            this.maxBuffers = Integer.parseInt(val);
        }
        this.showConfig(key, this.maxBuffers);
        key = "maxLogFiles";
        val = prop.getProperty("maxLogFiles");
        if (val != null) {
            this.maxLogFiles = Integer.parseInt(val);
        }
        this.showConfig(key, this.maxLogFiles);
        key = "threadsWaitingForceThreshold";
        val = prop.getProperty("threadsWaitingForceThreshold");
        if (val != null) {
            this.threadsWaitingForceThreshold = Integer.parseInt(val);
        }
        this.showConfig(key, this.threadsWaitingForceThreshold);
    }

    public String getLogFileDir() {
        return this.logFileDir;
    }

    public void setLogFileDir(String logDir) {
        this.logFileDir = logDir;
    }

    public String getLogFileExt() {
        return this.logFileExt;
    }

    public void setLogFileExt(String logFileExt) {
        this.logFileExt = logFileExt;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        this.logFileName = logFileName;
    }

    public boolean isChecksumEnabled() {
        return this.checksumEnabled;
    }

    public void setChecksumEnabled(boolean checksumOption) {
        this.checksumEnabled = checksumOption;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize * 1024;
    }

    public String getBufferClassName() {
        return this.bufferClassName;
    }

    public void setBufferClassName(String bufferClassName) {
        this.bufferClassName = bufferClassName;
    }

    public int getMaxBuffers() {
        return this.maxBuffers;
    }

    public void setMaxBuffers(int maxBuffers) {
        this.maxBuffers = maxBuffers;
    }

    public int getMinBuffers() {
        return this.minBuffers;
    }

    public void setMinBuffers(int minBuffers) {
        this.minBuffers = minBuffers;
    }

    public int getFlushSleepTime() {
        return this.flushSleepTime;
    }

    public void setFlushSleepTime(int flushSleepTime) {
        this.flushSleepTime = flushSleepTime;
    }

    public int getThreadsWaitingForceThreshold() {
        return this.threadsWaitingForceThreshold;
    }

    public void setThreadsWaitingForceThreshold(int threadsWaitingForceThreshold) {
        this.threadsWaitingForceThreshold = threadsWaitingForceThreshold;
    }

    public int getMaxBlocksPerFile() {
        return this.maxBlocksPerFile;
    }

    public void setMaxBlocksPerFile(int maxBlocksPerFile) {
        this.maxBlocksPerFile = maxBlocksPerFile;
    }

    public int getMaxLogFiles() {
        return this.maxLogFiles;
    }

    public void setMaxLogFiles(int maxLogFiles) {
        this.maxLogFiles = maxLogFiles;
    }
}

