/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.adapter;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.ServiceImplementationFactory;
import org.apache.hivemind.ServiceImplementationFactoryParameters;
import org.apache.hivemind.lib.adapter.AdapterMessages;
import org.apache.hivemind.lib.adapter.AdapterRegistryContribution;
import org.apache.hivemind.lib.adapter.AdapterRegistryParameter;
import org.apache.hivemind.lib.util.AdapterRegistry;
import org.apache.hivemind.lib.util.AdapterRegistryImpl;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodIterator;
import org.apache.hivemind.service.MethodSignature;

public class AdapterRegistryFactory
implements ServiceImplementationFactory {
    private ClassFactory _classFactory;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$hivemind$lib$util$AdapterRegistry;

    public Object createCoreServiceImplementation(ServiceImplementationFactoryParameters factoryParameters) {
        AdapterRegistryImpl ar = new AdapterRegistryImpl();
        this.buildAdapterRegistry(factoryParameters, ar);
        Class implClass = this.buildImplementationClass(factoryParameters);
        try {
            Constructor<?> c = implClass.getConstructors()[0];
            return c.newInstance(ar);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), HiveMind.getLocation((Object)factoryParameters.getFirstParameter()), (Throwable)ex);
        }
    }

    void buildAdapterRegistry(ServiceImplementationFactoryParameters factoryParameters, AdapterRegistry ar) {
        Class serviceInterface = factoryParameters.getServiceInterface();
        AdapterRegistryParameter p = (AdapterRegistryParameter)((Object)factoryParameters.getFirstParameter());
        List contributions = p.getContributions();
        Iterator i = contributions.iterator();
        while (i.hasNext()) {
            AdapterRegistryContribution c = (AdapterRegistryContribution)((Object)i.next());
            try {
                Object adapter = c.getAdapter();
                if (!serviceInterface.isAssignableFrom(adapter.getClass())) {
                    throw new ClassCastException(AdapterMessages.adapterWrongInterface(adapter, c.getRegisterClass(), serviceInterface));
                }
                ar.register(c.getRegisterClass(), adapter);
            }
            catch (Exception ex) {
                factoryParameters.getErrorLog().error(ex.getMessage(), c.getLocation(), (Throwable)ex);
            }
        }
    }

    private Class buildImplementationClass(ServiceImplementationFactoryParameters factoryParameters) {
        String name = ClassFabUtils.generateClassName((Class)factoryParameters.getServiceInterface());
        return this.buildImplementationClass(factoryParameters, name);
    }

    Class buildImplementationClass(ServiceImplementationFactoryParameters factoryParameters, String name) {
        Class serviceInterface = factoryParameters.getServiceInterface();
        ClassFab cf = this._classFactory.newClass(name, class$java$lang$Object == null ? (class$java$lang$Object = AdapterRegistryFactory.class$("java.lang.Object")) : class$java$lang$Object);
        cf.addInterface(serviceInterface);
        cf.addField("_adapterRegistry", class$org$apache$hivemind$lib$util$AdapterRegistry == null ? (class$org$apache$hivemind$lib$util$AdapterRegistry = AdapterRegistryFactory.class$("org.apache.hivemind.lib.util.AdapterRegistry")) : class$org$apache$hivemind$lib$util$AdapterRegistry);
        cf.addConstructor(new Class[]{class$org$apache$hivemind$lib$util$AdapterRegistry == null ? (class$org$apache$hivemind$lib$util$AdapterRegistry = AdapterRegistryFactory.class$("org.apache.hivemind.lib.util.AdapterRegistry")) : class$org$apache$hivemind$lib$util$AdapterRegistry}, null, "_adapterRegistry = $1;");
        cf.addMethod(2, new MethodSignature(serviceInterface, "_getAdapter", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = AdapterRegistryFactory.class$("java.lang.Object")) : class$java$lang$Object}, null), "return (" + serviceInterface.getName() + ") _adapterRegistry.getAdapter($1.getClass());");
        MethodIterator i = new MethodIterator(serviceInterface);
        while (i.hasNext()) {
            MethodSignature sig = i.next();
            if (this.proper(sig)) {
                this.addAdaptedMethod(cf, sig);
                continue;
            }
            ClassFabUtils.addNoOpMethod((ClassFab)cf, (MethodSignature)sig);
            factoryParameters.getErrorLog().error(AdapterMessages.improperServiceMethod(sig), HiveMind.getLocation((Object)factoryParameters.getFirstParameter()), null);
        }
        if (!i.getToString()) {
            ClassFabUtils.addToStringMethod((ClassFab)cf, (String)AdapterMessages.toString(factoryParameters.getServiceId(), serviceInterface));
        }
        return cf.createClass();
    }

    private void addAdaptedMethod(ClassFab cf, MethodSignature sig) {
        String body = "return ($r) _getAdapter($1)." + sig.getName() + "($$);";
        cf.addMethod(1, sig, body);
    }

    private boolean proper(MethodSignature sig) {
        Class[] parameterTypes = sig.getParameterTypes();
        return parameterTypes != null && parameterTypes.length > 0 && !parameterTypes[0].isPrimitive();
    }

    public void setClassFactory(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

