/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.pipeline;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.Location;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.lib.DefaultImplementationBuilder;
import org.apache.hivemind.lib.pipeline.BridgeBuilder;
import org.apache.hivemind.lib.pipeline.FilterHolder;
import org.apache.hivemind.lib.pipeline.PipelineMessages;
import org.apache.hivemind.order.Orderer;
import org.apache.hivemind.service.ClassFactory;

public class PipelineAssembler
extends BaseLocatable {
    private Log _log;
    private ErrorHandler _errorHandler;
    private String _serviceId;
    private Class _serviceInterface;
    private Class _filterInterface;
    private ClassFactory _classFactory;
    private DefaultImplementationBuilder _defaultBuilder;
    private Module _module;
    private Orderer _orderer;
    private Object _terminator;
    private Location _terminatorLocation;

    public PipelineAssembler(Log log, ErrorHandler errorHandler, String serviceId, Class serviceInterface, Class filterInterface, ClassFactory classFactory, DefaultImplementationBuilder defaultBuilder, Module module) {
        this._log = log;
        this._errorHandler = errorHandler;
        this._serviceId = serviceId;
        this._serviceInterface = serviceInterface;
        this._filterInterface = filterInterface;
        this._classFactory = classFactory;
        this._defaultBuilder = defaultBuilder;
        this._module = module;
        this._orderer = new Orderer(this._log, errorHandler, "filter");
    }

    public void addFilter(String name, String prereqs, String postreqs, Object filter, Location location) {
        if (!this.checkInterface(this._filterInterface, filter, location)) {
            return;
        }
        FilterHolder holder = new FilterHolder(filter, location);
        this._orderer.add((Object)holder, name, prereqs, postreqs);
    }

    public void setTerminator(Object terminator, Location terminatorLocation) {
        if (this._terminator != null) {
            this._errorHandler.error(this._log, PipelineMessages.duplicateTerminator(terminator, this._serviceId, this._terminator, this._terminatorLocation), terminatorLocation, null);
            return;
        }
        if (!this.checkInterface(this._serviceInterface, terminator, terminatorLocation)) {
            return;
        }
        this._terminator = terminator;
        this._terminatorLocation = terminatorLocation;
    }

    Object getTerminator() {
        return this._terminator;
    }

    private boolean checkInterface(Class interfaceType, Object instance, Location location) {
        if (interfaceType.isAssignableFrom(instance.getClass())) {
            return true;
        }
        this._errorHandler.error(this._log, PipelineMessages.incorrectInterface(instance, interfaceType, this._serviceId), location, null);
        return false;
    }

    public Object createPipeline() {
        List filterHolders = this._orderer.getOrderedObjects();
        int count = filterHolders.size();
        BridgeBuilder bb = count == 0 ? null : new BridgeBuilder(this._log, this._serviceId, this._serviceInterface, this._filterInterface, this._classFactory, this._module);
        Object next = this._terminator != null ? this._terminator : this._defaultBuilder.buildDefaultImplementation(this._serviceInterface, this._module);
        int i = count - 1;
        while (i >= 0) {
            FilterHolder h = (FilterHolder)filterHolders.get(i);
            Object filter = h.getFilter();
            next = bb.instantiateBridge(next, filter);
            --i;
        }
        return next;
    }
}

