/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.pipeline;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.lib.pipeline.FilterMethodAnalyzer;
import org.apache.hivemind.lib.pipeline.PipelineMessages;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodSignature;

class BridgeBuilder {
    private Log _log;
    private String _serviceId;
    private Class _serviceInterface;
    private Class _filterInterface;
    private ClassFab _classFab;
    private FilterMethodAnalyzer _filterMethodAnalyzer;
    private Constructor _constructor;
    static /* synthetic */ Class class$java$lang$Object;

    BridgeBuilder(Log log, String serviceId, Class serviceInterface, Class filterInterface, ClassFactory classFactory, Module module) {
        this._log = log;
        this._serviceId = serviceId;
        this._serviceInterface = serviceInterface;
        this._filterInterface = filterInterface;
        String name = ClassFabUtils.generateClassName((String)"PipelineBridge");
        this._classFab = classFactory.newClass(name, class$java$lang$Object == null ? (class$java$lang$Object = BridgeBuilder.class$("java.lang.Object")) : class$java$lang$Object, module);
        this._filterMethodAnalyzer = new FilterMethodAnalyzer(serviceInterface);
    }

    private void createClass() {
        boolean toStringMethodExists = false;
        ArrayList<MethodSignature> serviceMethods = new ArrayList<MethodSignature>();
        ArrayList<MethodSignature> filterMethods = new ArrayList<MethodSignature>();
        this.createInfrastructure();
        Method[] methods = this._serviceInterface.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            toStringMethodExists |= ClassFabUtils.isToString((Method)m);
            serviceMethods.add(new MethodSignature(m));
            ++i;
        }
        methods = this._filterInterface.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            Method m = methods[i2];
            filterMethods.add(new MethodSignature(m));
            ++i2;
        }
        while (!serviceMethods.isEmpty()) {
            MethodSignature ms = (MethodSignature)serviceMethods.remove(0);
            this.addBridgeMethod(ms, filterMethods);
        }
        this.reportExtraFilterMethods(filterMethods);
        if (!toStringMethodExists) {
            ClassFabUtils.addToStringMethod((ClassFab)this._classFab, (String)PipelineMessages.bridgeInstanceDescription(this._serviceId, this._serviceInterface));
        }
        Class bridgeClass = this._classFab.createClass();
        this._constructor = bridgeClass.getConstructors()[0];
    }

    private void createInfrastructure() {
        this._classFab.addField("_next", this._serviceInterface);
        this._classFab.addField("_filter", this._filterInterface);
        this._classFab.addConstructor(new Class[]{this._serviceInterface, this._filterInterface}, null, "{ _next = $1; _filter = $2; }");
        this._classFab.addInterface(this._serviceInterface);
    }

    public Object instantiateBridge(Object nextBridge, Object filter) {
        if (this._constructor == null) {
            this.createClass();
        }
        try {
            return this._constructor.newInstance(nextBridge, filter);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException((Throwable)ex);
        }
    }

    private void reportExtraFilterMethods(List filterMethods) {
        Iterator i = filterMethods.iterator();
        while (i.hasNext()) {
            MethodSignature ms = (MethodSignature)i.next();
            this._log.error((Object)PipelineMessages.extraFilterMethod(ms, this._filterInterface, this._serviceInterface, this._serviceId));
        }
    }

    private void addBridgeMethod(MethodSignature ms, List filterMethods) {
        Iterator i = filterMethods.iterator();
        while (i.hasNext()) {
            MethodSignature fms = (MethodSignature)i.next();
            int position = this._filterMethodAnalyzer.findServiceInterfacePosition(ms, fms);
            if (position < 0) continue;
            this.addBridgeMethod(position, ms, fms);
            i.remove();
            return;
        }
        String message = PipelineMessages.unmatchedServiceMethod(ms, this._filterInterface);
        this._log.error((Object)message);
        BodyBuilder b = new BodyBuilder();
        b.add("throw new org.apache.hivemind.ApplicationRuntimeException(");
        b.addQuoted(message);
        b.addln(");");
        this._classFab.addMethod(1, ms, b.toString());
    }

    private void addBridgeMethod(int position, MethodSignature ms, MethodSignature fms) {
        StringBuffer buffer = new StringBuffer(100);
        if (ms.getReturnType() != Void.TYPE) {
            buffer.append("return ");
        }
        buffer.append("_filter.");
        buffer.append(ms.getName());
        buffer.append("(");
        boolean comma = false;
        int filterParameterCount = fms.getParameterTypes().length;
        int i = 0;
        while (i < position) {
            if (comma) {
                buffer.append(", ");
            }
            buffer.append("$");
            buffer.append(i + 1);
            comma = true;
            ++i;
        }
        if (comma) {
            buffer.append(", ");
        }
        buffer.append("_next");
        int i2 = position + 1;
        while (i2 < filterParameterCount) {
            buffer.append(", $");
            buffer.append(i2);
            ++i2;
        }
        buffer.append(");");
        this._classFab.addMethod(1, ms, buffer.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

