/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.impl;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ServiceImplementationFactory;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.lib.impl.ImplMessages;
import org.apache.hivemind.lib.impl.ServicePropertyFactoryParameter;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.ConstructorUtils;
import org.apache.hivemind.util.PropertyAdaptor;
import org.apache.hivemind.util.PropertyUtils;

public class ServicePropertyFactory
implements ServiceImplementationFactory {
    private ClassFactory _classFactory;
    static /* synthetic */ Class class$java$lang$Object;

    public Object createCoreServiceImplementation(String serviceId, Class serviceInterface, Log serviceLog, Module invokingModule, List parameters) {
        String propertyName;
        ServicePropertyFactoryParameter p = (ServicePropertyFactoryParameter)((Object)parameters.get(0));
        Object targetService = p.getService();
        PropertyAdaptor pa = PropertyUtils.getPropertyAdaptor((Object)targetService, (String)(propertyName = p.getPropertyName()));
        String readMethodName = pa.getReadMethodName();
        if (readMethodName == null) {
            throw new ApplicationRuntimeException(ImplMessages.servicePropertyNotReadable(propertyName, targetService), null, p.getLocation(), null);
        }
        if (!serviceInterface.isAssignableFrom(pa.getPropertyType())) {
            throw new ApplicationRuntimeException(ImplMessages.servicePropertyWrongType(propertyName, targetService, pa.getPropertyType(), serviceInterface), p.getLocation(), null);
        }
        String name = ClassFabUtils.generateClassName((String)"ServicePropertyProxy");
        ClassFab cf = this._classFactory.newClass(name, class$java$lang$Object == null ? (class$java$lang$Object = ServicePropertyFactory.class$("java.lang.Object")) : class$java$lang$Object, invokingModule);
        this.addInfrastructure(cf, targetService, serviceInterface, propertyName, readMethodName);
        this.addMethods(cf, serviceId, serviceInterface, propertyName, targetService);
        Class proxyClass = cf.createClass();
        try {
            return ConstructorUtils.invokeConstructor((Class)proxyClass, (Object[])new Object[]{targetService});
        }
        catch (ApplicationRuntimeException ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), p.getLocation(), (Throwable)ex);
        }
    }

    private void addInfrastructure(ClassFab cf, Object targetService, Class serviceInterface, String propertyName, String readPropertyMethodName) {
        cf.addInterface(serviceInterface);
        Class<?> targetServiceClass = targetService.getClass();
        cf.addField("_targetService", targetServiceClass);
        cf.addConstructor(new Class[]{targetServiceClass}, null, "{ super(); _targetService = $1; }");
        BodyBuilder b = new BodyBuilder();
        b.begin();
        b.addln("{0} property = _targetService.{1}();", (Object)serviceInterface.getName(), (Object)readPropertyMethodName);
        b.addln("if (property == null)");
        b.add("  throw new java.lang.NullPointerException(");
        b.addQuoted(ImplMessages.servicePropertyWasNull(propertyName, targetService));
        b.addln(");");
        b.addln("return property;");
        b.end();
        MethodSignature sig = new MethodSignature(serviceInterface, "_targetServiceProperty", null, null);
        cf.addMethod(18, sig, b.toString());
    }

    private void addMethods(ClassFab cf, String serviceId, Class serviceInterface, String propertyName, Object targetService) {
        boolean toString = false;
        Method[] methods = serviceInterface.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            toString |= ClassFabUtils.isToString((Method)method);
            String body = "return ($r) _targetServiceProperty()." + method.getName() + "($$);";
            cf.addMethod(1, new MethodSignature(method), body);
            ++i;
        }
        if (!toString) {
            ClassFabUtils.addToStringMethod((ClassFab)cf, (String)ImplMessages.servicePropertyToString(serviceId, serviceInterface, propertyName, targetService));
        }
    }

    public void setClassFactory(ClassFactory factory) {
        this._classFactory = factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

