/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.factory;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.lib.BeanFactory;
import org.apache.hivemind.lib.factory.BeanFactoryContribution;
import org.apache.hivemind.lib.factory.FactoryMessages;

public class BeanFactoryImpl
extends BaseLocatable
implements BeanFactory {
    private Log _log;
    private ErrorHandler _errorHandler;
    private Class _vendType;
    private Map _contributions = new HashMap();
    private Map _cache = new HashMap();
    private boolean _defaultCacheable;
    static /* synthetic */ Class class$java$lang$String;

    public BeanFactoryImpl(Log log, ErrorHandler errorHandler, Class vendType, List contributions, boolean defaultCacheable) {
        this._log = log;
        this._errorHandler = errorHandler;
        this._vendType = vendType;
        this._defaultCacheable = defaultCacheable;
        this.processContributions(contributions);
    }

    private void processContributions(List list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            BeanFactoryContribution c = (BeanFactoryContribution)((Object)i.next());
            Class beanClass = c.getBeanClass();
            if (beanClass.isInterface() || beanClass.isArray() || beanClass.isPrimitive()) {
                this._errorHandler.error(this._log, FactoryMessages.invalidContributionClass(c), c.getLocation(), null);
                continue;
            }
            if (!this._vendType.isAssignableFrom(beanClass)) {
                this._errorHandler.error(this._log, FactoryMessages.wrongContributionType(c, this._vendType), c.getLocation(), null);
                continue;
            }
            String name = c.getName();
            BeanFactoryContribution existing = (BeanFactoryContribution)((Object)this._contributions.get(name));
            if (existing != null) {
                this._errorHandler.error(this._log, FactoryMessages.dupeContribution(existing), existing.getLocation(), null);
                continue;
            }
            this._contributions.put(name, c);
        }
    }

    public synchronized Object get(String locator) {
        Object result = this._cache.get(locator);
        if (result == null) {
            result = this.create(locator);
        }
        return result;
    }

    private Object create(String locator) {
        int commax = locator.indexOf(44);
        String name = commax < 0 ? locator.trim() : locator.substring(0, commax);
        String initializer = commax < 0 ? null : locator.substring(commax + 1).trim();
        BeanFactoryContribution c = (BeanFactoryContribution)((Object)this._contributions.get(name));
        if (c == null) {
            throw new ApplicationRuntimeException(FactoryMessages.unknownContribution(name));
        }
        Object result = this.construct(c, initializer);
        if (c.getStoreResultInCache(this._defaultCacheable)) {
            this._cache.put(locator, result);
        }
        return result;
    }

    private Object construct(BeanFactoryContribution contribution, String initializer) {
        Class beanClass = contribution.getBeanClass();
        try {
            if (HiveMind.isBlank((String)initializer)) {
                return beanClass.newInstance();
            }
            Constructor c = beanClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BeanFactoryImpl.class$("java.lang.String")) : class$java$lang$String);
            return c.newInstance(initializer);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(FactoryMessages.unableToInstantiate(beanClass, ex), contribution.getLocation(), (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

