/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.pipeline;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.ServiceImplementationFactory;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.lib.DefaultImplementationBuilder;
import org.apache.hivemind.lib.pipeline.PipelineAssembler;
import org.apache.hivemind.lib.pipeline.PipelineContribution;
import org.apache.hivemind.lib.pipeline.PipelineParameters;
import org.apache.hivemind.service.ClassFactory;

public class PipelineFactory
extends BaseLocatable
implements ServiceImplementationFactory {
    private String _serviceId;
    private ClassFactory _classFactory;
    private DefaultImplementationBuilder _defaultImplementationBuilder;
    private ErrorHandler _errorHandler;

    public Object createCoreServiceImplementation(String string, Class clazz, Module module, List list) {
        HiveMind.checkFactoryParameterCount((String)this._serviceId, (List)list, (int)1);
        PipelineParameters pipelineParameters = (PipelineParameters)((Object)list.get(0));
        PipelineAssembler pipelineAssembler = new PipelineAssembler(LogFactory.getLog((String)string), this._errorHandler, string, clazz, pipelineParameters.getFilterInterface(), this._classFactory, this._defaultImplementationBuilder, module);
        Object object = pipelineParameters.getTerminator();
        if (object != null) {
            pipelineAssembler.setTerminator(object, pipelineParameters.getLocation());
        }
        List list2 = pipelineParameters.getPipelineConfiguration();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            PipelineContribution pipelineContribution = (PipelineContribution)iterator.next();
            pipelineContribution.informAssembler(pipelineAssembler);
        }
        return pipelineAssembler.createPipeline();
    }

    public void setClassFactory(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    public void setDefaultImplementationBuilder(DefaultImplementationBuilder defaultImplementationBuilder) {
        this._defaultImplementationBuilder = defaultImplementationBuilder;
    }

    public void setServiceId(String string) {
        this._serviceId = string;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }
}

