/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.pipeline;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.Location;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.lib.DefaultImplementationBuilder;
import org.apache.hivemind.lib.pipeline.BridgeBuilder;
import org.apache.hivemind.lib.pipeline.FilterHolder;
import org.apache.hivemind.lib.pipeline.PipelineMessages;
import org.apache.hivemind.order.Orderer;
import org.apache.hivemind.service.ClassFactory;

public class PipelineAssembler
extends BaseLocatable {
    private Log _log;
    private ErrorHandler _errorHandler;
    private String _serviceId;
    private Class _serviceInterface;
    private Class _filterInterface;
    private ClassFactory _classFactory;
    private DefaultImplementationBuilder _defaultBuilder;
    private Module _module;
    private Orderer _orderer;
    private Object _terminator;
    private Location _terminatorLocation;

    public PipelineAssembler(Log log, ErrorHandler errorHandler, String string, Class clazz, Class clazz2, ClassFactory classFactory, DefaultImplementationBuilder defaultImplementationBuilder, Module module) {
        this._log = log;
        this._errorHandler = errorHandler;
        this._serviceId = string;
        this._serviceInterface = clazz;
        this._filterInterface = clazz2;
        this._classFactory = classFactory;
        this._defaultBuilder = defaultImplementationBuilder;
        this._module = module;
        this._orderer = new Orderer(this._log, errorHandler, "filter");
    }

    public void addFilter(String string, String string2, String string3, Object object, Location location) {
        if (!this.checkInterface(this._filterInterface, object, location)) {
            return;
        }
        FilterHolder filterHolder = new FilterHolder(object, location);
        this._orderer.add((Object)filterHolder, string, string2, string3);
    }

    public void setTerminator(Object object, Location location) {
        if (this._terminator != null) {
            this._errorHandler.error(this._log, PipelineMessages.duplicateTerminator(object, this._serviceId, this._terminator, this._terminatorLocation), location, null);
            return;
        }
        if (!this.checkInterface(this._serviceInterface, object, location)) {
            return;
        }
        this._terminator = object;
        this._terminatorLocation = location;
    }

    Object getTerminator() {
        return this._terminator;
    }

    private boolean checkInterface(Class clazz, Object object, Location location) {
        if (clazz.isAssignableFrom(object.getClass())) {
            return true;
        }
        this._errorHandler.error(this._log, PipelineMessages.incorrectInterface(object, clazz, this._serviceId), location, null);
        return false;
    }

    public Object createPipeline() {
        List list = this._orderer.getOrderedObjects();
        int n = list.size();
        BridgeBuilder bridgeBuilder = n == 0 ? null : new BridgeBuilder(this._log, this._serviceId, this._serviceInterface, this._filterInterface, this._classFactory, this._module);
        Object object = this._terminator != null ? this._terminator : this._defaultBuilder.buildDefaultImplementation(this._serviceInterface, this._module);
        int n2 = n - 1;
        while (n2 >= 0) {
            FilterHolder filterHolder = (FilterHolder)list.get(n2);
            Object object2 = filterHolder.getFilter();
            object = bridgeBuilder.instantiateBridge(object, object2);
            --n2;
        }
        return object;
    }
}

