/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.pipeline;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.lib.pipeline.FilterMethodAnalyzer;
import org.apache.hivemind.lib.pipeline.PipelineMessages;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodSignature;

class BridgeBuilder {
    private Log _log;
    private String _serviceId;
    private Class _serviceInterface;
    private Class _filterInterface;
    private ClassFab _classFab;
    private FilterMethodAnalyzer _filterMethodAnalyzer;
    private Constructor _constructor;
    static /* synthetic */ Class class$java$lang$Object;

    BridgeBuilder(Log log, String string, Class clazz, Class clazz2, ClassFactory classFactory, Module module) {
        this._log = log;
        this._serviceId = string;
        this._serviceInterface = clazz;
        this._filterInterface = clazz2;
        String string2 = ClassFabUtils.generateClassName((String)"PipelineBridge");
        this._classFab = classFactory.newClass(string2, class$java$lang$Object == null ? (class$java$lang$Object = BridgeBuilder.class$("java.lang.Object")) : class$java$lang$Object, module);
        this._filterMethodAnalyzer = new FilterMethodAnalyzer(clazz);
    }

    private void createClass() {
        GenericDeclaration genericDeclaration;
        boolean bl = false;
        ArrayList<MethodSignature> arrayList = new ArrayList<MethodSignature>();
        ArrayList<MethodSignature> arrayList2 = new ArrayList<MethodSignature>();
        this.createInfrastructure();
        Method[] methodArray = this._serviceInterface.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            bl |= ClassFabUtils.isToString((Method)method);
            arrayList.add(new MethodSignature(method));
            ++n;
        }
        methodArray = this._filterInterface.getMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            genericDeclaration = methodArray[n2];
            arrayList2.add(new MethodSignature((Method)genericDeclaration));
            ++n2;
        }
        while (!arrayList.isEmpty()) {
            genericDeclaration = (MethodSignature)arrayList.remove(0);
            this.addBridgeMethod((MethodSignature)genericDeclaration, arrayList2);
        }
        this.reportExtraFilterMethods(arrayList2);
        if (!bl) {
            ClassFabUtils.addToStringMethod((ClassFab)this._classFab, (String)PipelineMessages.bridgeInstanceDescription(this._serviceId, this._serviceInterface));
        }
        genericDeclaration = this._classFab.createClass();
        this._constructor = ((Class)genericDeclaration).getConstructors()[0];
    }

    private void createInfrastructure() {
        this._classFab.addField("_next", this._serviceInterface);
        this._classFab.addField("_filter", this._filterInterface);
        this._classFab.addConstructor(new Class[]{this._serviceInterface, this._filterInterface}, null, "{ _next = $1; _filter = $2; }");
        this._classFab.addInterface(this._serviceInterface);
    }

    public Object instantiateBridge(Object object, Object object2) {
        if (this._constructor == null) {
            this.createClass();
        }
        try {
            return this._constructor.newInstance(object, object2);
        }
        catch (Exception exception) {
            throw new ApplicationRuntimeException((Throwable)exception);
        }
    }

    private void reportExtraFilterMethods(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MethodSignature methodSignature = (MethodSignature)iterator.next();
            this._log.error((Object)PipelineMessages.extraFilterMethod(methodSignature, this._filterInterface, this._serviceInterface, this._serviceId));
        }
    }

    private void addBridgeMethod(MethodSignature methodSignature, List list) {
        Object object;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (MethodSignature)iterator.next();
            int n = this._filterMethodAnalyzer.findServiceInterfacePosition(methodSignature, (MethodSignature)object);
            if (n < 0) continue;
            this.addBridgeMethod(n, methodSignature, (MethodSignature)object);
            iterator.remove();
            return;
        }
        object = PipelineMessages.unmatchedServiceMethod(methodSignature, this._filterInterface);
        this._log.error(object);
        BodyBuilder bodyBuilder = new BodyBuilder();
        bodyBuilder.add("throw new org.apache.hivemind.ApplicationRuntimeException(");
        bodyBuilder.addQuoted((String)object);
        bodyBuilder.addln(");");
        this._classFab.addMethod(1, methodSignature, bodyBuilder.toString());
    }

    private void addBridgeMethod(int n, MethodSignature methodSignature, MethodSignature methodSignature2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (methodSignature.getReturnType() != Void.TYPE) {
            stringBuffer.append("return ");
        }
        stringBuffer.append("_filter.");
        stringBuffer.append(methodSignature.getName());
        stringBuffer.append("(");
        boolean bl = false;
        int n2 = methodSignature2.getParameterTypes().length;
        int n3 = 0;
        while (n3 < n) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("$");
            stringBuffer.append(n3 + 1);
            bl = true;
            ++n3;
        }
        if (bl) {
            stringBuffer.append(", ");
        }
        stringBuffer.append("_next");
        int n4 = n + 1;
        while (n4 < n2) {
            stringBuffer.append(", $");
            stringBuffer.append(n4);
            ++n4;
        }
        stringBuffer.append(");");
        this._classFab.addMethod(1, methodSignature, stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

