/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.lib.RemoteExceptionCoordinator;
import org.apache.hivemind.lib.RemoteExceptionEvent;
import org.apache.hivemind.lib.RemoteExceptionListener;
import org.apache.hivemind.lib.impl.ImplMessages;

public class RemoteExceptionCoordinatorImpl
implements RemoteExceptionCoordinator {
    private boolean _locked;
    private List _listeners;

    private void checkLocked(String string) {
        if (this._locked) {
            throw new ApplicationRuntimeException(ImplMessages.coordinatorLocked(string));
        }
    }

    public synchronized void addRemoteExceptionListener(RemoteExceptionListener remoteExceptionListener) {
        this.checkLocked("addRemoteExceptionListener");
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(remoteExceptionListener);
    }

    public synchronized void removeRemoteExceptionListener(RemoteExceptionListener remoteExceptionListener) {
        this.checkLocked("removeRemoteExceptionListener");
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(remoteExceptionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireRemoteExceptionDidOccur(Object object, Throwable throwable) {
        this.checkLocked("sendNotification");
        if (this._listeners == null || this._listeners.size() == 0) {
            return;
        }
        RemoteExceptionEvent remoteExceptionEvent = new RemoteExceptionEvent(object, throwable);
        int n = this._listeners.size();
        this._locked = true;
        try {
            int n2 = 0;
            while (n2 < n) {
                RemoteExceptionListener remoteExceptionListener = (RemoteExceptionListener)this._listeners.get(n2);
                remoteExceptionListener.remoteExceptionDidOccur(remoteExceptionEvent);
                ++n2;
            }
            Object var8_7 = null;
            this._locked = false;
        }
        catch (Throwable throwable2) {
            Object var8_8 = null;
            this._locked = false;
            throw throwable2;
        }
    }
}

