/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.impl;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.lib.NameLookup;
import org.apache.hivemind.lib.RemoteExceptionCoordinator;
import org.apache.hivemind.lib.RemoteExceptionEvent;
import org.apache.hivemind.lib.RemoteExceptionListener;
import org.apache.hivemind.lib.impl.ImplMessages;

public class NameLookupImpl
implements NameLookup,
RemoteExceptionListener {
    private RemoteExceptionCoordinator _coordinator;
    private InitialContext _initialContext;
    private String _initialFactory;
    private String _URLPackages;
    private String _providerURL;

    public Object lookup(String string, Class clazz) {
        Object object;
        int n = 0;
        while (true) {
            Context context = null;
            object = null;
            try {
                context = this.getInitialContext();
                object = context.lookup(string);
            }
            catch (NamingException namingException) {
                if (n++ == 0) {
                    this._coordinator.fireRemoteExceptionDidOccur(this, namingException);
                    continue;
                }
                throw new ApplicationRuntimeException(ImplMessages.unableToLookup(string, context), (Throwable)namingException);
            }
            break;
        }
        if (object == null) {
            throw new ApplicationRuntimeException(ImplMessages.noObject(string, clazz));
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new ApplicationRuntimeException(ImplMessages.wrongType(string, object, clazz));
        }
        return object;
    }

    private Context getInitialContext() throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (!HiveMind.isBlank((String)this._initialFactory)) {
            hashtable.put("java.naming.factory.initial", this._initialFactory);
        }
        if (!HiveMind.isBlank((String)this._providerURL)) {
            hashtable.put("java.naming.provider.url", this._providerURL);
        }
        if (!HiveMind.isBlank((String)this._URLPackages)) {
            hashtable.put("java.naming.factory.url.pkgs", this._URLPackages);
        }
        return this.constructContext(hashtable);
    }

    protected Context constructContext(Hashtable hashtable) throws NamingException {
        return new InitialContext(hashtable);
    }

    public void remoteExceptionDidOccur(RemoteExceptionEvent remoteExceptionEvent) {
        this._initialContext = null;
    }

    public void setInitialFactory(String string) {
        this._initialFactory = string;
    }

    public void setProviderURL(String string) {
        this._providerURL = string;
    }

    public void setURLPackages(String string) {
        this._URLPackages = string;
    }

    public void setCoordinator(RemoteExceptionCoordinator remoteExceptionCoordinator) {
        this._coordinator = remoteExceptionCoordinator;
    }
}

