/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.ServiceImplementationFactory;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.lib.NameLookup;
import org.apache.hivemind.lib.RemoteExceptionCoordinator;
import org.apache.hivemind.lib.impl.EJBProxyParameters;
import org.apache.hivemind.lib.impl.ImplMessages;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodSignature;

public class EJBProxyFactory
extends BaseLocatable
implements ServiceImplementationFactory {
    private String _pointId;
    private NameLookup _nameLookup;
    private RemoteExceptionCoordinator _coordinator;
    private ClassFactory _classFactory;
    static /* synthetic */ Class class$org$apache$hivemind$lib$impl$AbstractEJBProxy;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$org$apache$hivemind$lib$NameLookup;
    static /* synthetic */ Class class$org$apache$hivemind$lib$RemoteExceptionCoordinator;

    public Object createCoreServiceImplementation(String string, Class clazz, Module module, List list) {
        HiveMind.checkFactoryParameterCount((String)this._pointId, (List)list, (int)1);
        EJBProxyParameters eJBProxyParameters = (EJBProxyParameters)list.get(0);
        String string2 = eJBProxyParameters.getJndiName();
        String string3 = eJBProxyParameters.getHomeInterfaceClassName();
        Class clazz2 = module.getClassResolver().findClass(string3);
        String string4 = ClassFabUtils.generateClassName((String)"EJBProxy");
        ClassFab classFab = this._classFactory.newClass(string4, class$org$apache$hivemind$lib$impl$AbstractEJBProxy == null ? (class$org$apache$hivemind$lib$impl$AbstractEJBProxy = EJBProxyFactory.class$("org.apache.hivemind.lib.impl.AbstractEJBProxy")) : class$org$apache$hivemind$lib$impl$AbstractEJBProxy, module);
        classFab.addInterface(clazz);
        classFab.addField("_remote", clazz);
        this.addClearCachedMethod(classFab);
        this.addLookupMethod(classFab, clazz2, clazz, string2);
        this.addServiceMethods(classFab, clazz, string, string2);
        this.addConstructor(classFab);
        Class clazz3 = classFab.createClass();
        return this.invokeConstructor(clazz3, eJBProxyParameters.getNameLookup(this._nameLookup));
    }

    private void addClearCachedMethod(ClassFab classFab) {
        classFab.addMethod(4, new MethodSignature(Void.TYPE, "_clearCachedReferences", null, null), "_remote = null;");
    }

    private void addLookupMethod(ClassFab classFab, Class clazz, Class clazz2, String string) {
        String string2 = clazz.getName();
        BodyBuilder bodyBuilder = new BodyBuilder();
        bodyBuilder.begin();
        bodyBuilder.addln("if (_remote != null)");
        bodyBuilder.addln("  return _remote;");
        bodyBuilder.add(string2);
        bodyBuilder.add(" home = (");
        bodyBuilder.add(string2);
        bodyBuilder.add(") _lookup(");
        bodyBuilder.addQuoted(string);
        bodyBuilder.addln(");");
        bodyBuilder.add("try");
        bodyBuilder.begin();
        bodyBuilder.add("_remote = home.create();");
        bodyBuilder.end();
        bodyBuilder.add("catch (javax.ejb.CreateException ex)");
        bodyBuilder.begin();
        bodyBuilder.add("throw new java.rmi.RemoteException(ex.getMessage(), ex);");
        bodyBuilder.end();
        bodyBuilder.add("return _remote;");
        bodyBuilder.end();
        classFab.addMethod(34, new MethodSignature(clazz2, "_lookupRemote", null, new Class[]{class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = EJBProxyFactory.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException}), bodyBuilder.toString());
    }

    private void addServiceMethods(ClassFab classFab, Class clazz, String string, String string2) {
        Method[] methodArray = clazz.getMethods();
        boolean bl = false;
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            this.addServiceMethod(classFab, method);
            bl |= ClassFabUtils.isToString((Method)method);
            ++n;
        }
        if (!bl) {
            this.addToStringMethod(classFab, clazz, string, string2);
        }
    }

    private void addServiceMethod(ClassFab classFab, Method method) {
        String string = method.getName();
        boolean bl = method.getReturnType().equals(Void.TYPE);
        BodyBuilder bodyBuilder = new BodyBuilder();
        bodyBuilder.begin();
        bodyBuilder.addln("boolean first = true;");
        bodyBuilder.add("while (true)");
        bodyBuilder.begin();
        bodyBuilder.add("try");
        bodyBuilder.begin();
        if (!bl) {
            bodyBuilder.add("return ");
        }
        bodyBuilder.add("_lookupRemote().");
        bodyBuilder.add(string);
        bodyBuilder.addln("($$);");
        if (bl) {
            bodyBuilder.addln("return;");
        }
        bodyBuilder.end();
        bodyBuilder.add("catch (java.rmi.RemoteException ex)");
        bodyBuilder.begin();
        bodyBuilder.addln("if (first)");
        bodyBuilder.begin();
        bodyBuilder.addln("_handleRemoteException(ex);");
        bodyBuilder.addln("first = false;");
        bodyBuilder.end();
        bodyBuilder.addln("else");
        bodyBuilder.add("  throw ex;");
        bodyBuilder.end();
        bodyBuilder.end();
        bodyBuilder.end();
        classFab.addMethod(1, new MethodSignature(method), bodyBuilder.toString());
    }

    private void addToStringMethod(ClassFab classFab, Class clazz, String string, String string2) {
        ClassFabUtils.addToStringMethod((ClassFab)classFab, (String)ImplMessages.ejbProxyDescription(string, clazz, string2));
    }

    private void addConstructor(ClassFab classFab) {
        classFab.addConstructor(new Class[]{class$org$apache$hivemind$lib$NameLookup == null ? (class$org$apache$hivemind$lib$NameLookup = EJBProxyFactory.class$("org.apache.hivemind.lib.NameLookup")) : class$org$apache$hivemind$lib$NameLookup, class$org$apache$hivemind$lib$RemoteExceptionCoordinator == null ? (class$org$apache$hivemind$lib$RemoteExceptionCoordinator = EJBProxyFactory.class$("org.apache.hivemind.lib.RemoteExceptionCoordinator")) : class$org$apache$hivemind$lib$RemoteExceptionCoordinator}, null, "super($1, $2);");
    }

    private Object invokeConstructor(Class clazz, NameLookup nameLookup) {
        try {
            Constructor constructor = clazz.getConstructor(class$org$apache$hivemind$lib$NameLookup == null ? (class$org$apache$hivemind$lib$NameLookup = EJBProxyFactory.class$("org.apache.hivemind.lib.NameLookup")) : class$org$apache$hivemind$lib$NameLookup, class$org$apache$hivemind$lib$RemoteExceptionCoordinator == null ? (class$org$apache$hivemind$lib$RemoteExceptionCoordinator = EJBProxyFactory.class$("org.apache.hivemind.lib.RemoteExceptionCoordinator")) : class$org$apache$hivemind$lib$RemoteExceptionCoordinator);
            return constructor.newInstance(nameLookup, this._coordinator);
        }
        catch (Exception exception) {
            throw new ApplicationRuntimeException((Throwable)exception);
        }
    }

    public void setPointId(String string) {
        this._pointId = string;
    }

    public void setClassFactory(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    public void setCoordinator(RemoteExceptionCoordinator remoteExceptionCoordinator) {
        this._coordinator = remoteExceptionCoordinator;
    }

    public void setNameLookup(NameLookup nameLookup) {
        this._nameLookup = nameLookup;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

