/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.impl;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.lib.DefaultImplementationBuilder;
import org.apache.hivemind.lib.impl.ImplMessages;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodSignature;

public class DefaultImplementationBuilderImpl
extends BaseLocatable
implements DefaultImplementationBuilder {
    private Map _instances = Collections.synchronizedMap(new HashMap());
    private ClassFactory _classFactory;
    static /* synthetic */ Class class$java$lang$Object;

    public Object buildDefaultImplementation(Class clazz, Module module) {
        Object object = this._instances.get(clazz);
        if (object == null) {
            object = this.create(clazz, module);
            this._instances.put(clazz, object);
        }
        return object;
    }

    private Object create(Class clazz, Module module) {
        Class clazz2 = this.createClass(clazz, module);
        try {
            return clazz2.newInstance();
        }
        catch (Exception exception) {
            throw new ApplicationRuntimeException(ImplMessages.unableToCreateDefaultImplementation(clazz, exception), (Throwable)exception);
        }
    }

    private Class createClass(Class clazz, Module module) {
        if (!clazz.isInterface()) {
            throw new ApplicationRuntimeException(ImplMessages.notAnInterface(clazz));
        }
        String string = ClassFabUtils.generateClassName((String)"DefaultImpl");
        ClassFab classFab = this._classFactory.newClass(string, class$java$lang$Object == null ? (class$java$lang$Object = DefaultImplementationBuilderImpl.class$("java.lang.Object")) : class$java$lang$Object, module);
        classFab.addInterface(clazz);
        boolean bl = false;
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            bl |= ClassFabUtils.isToString((Method)method);
            this.addMethod(classFab, method);
            ++n;
        }
        if (!bl) {
            ClassFabUtils.addToStringMethod((ClassFab)classFab, (String)ImplMessages.defaultImplementationDescription(clazz));
        }
        return classFab.createClass();
    }

    private void addMethod(ClassFab classFab, Method method) {
        StringBuffer stringBuffer = new StringBuffer("{ ");
        Class<?> clazz = method.getReturnType();
        if (clazz != Void.TYPE) {
            stringBuffer.append("return ");
            if (clazz.isPrimitive()) {
                if (clazz == Boolean.TYPE) {
                    stringBuffer.append("false");
                } else {
                    stringBuffer.append("0");
                }
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(";");
        }
        stringBuffer.append(" }");
        classFab.addMethod(1, new MethodSignature(method), stringBuffer.toString());
    }

    public void setClassFactory(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

