/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.factory;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.lib.BeanFactory;
import org.apache.hivemind.lib.factory.BeanFactoryContribution;
import org.apache.hivemind.lib.factory.FactoryMessages;

public class BeanFactoryImpl
extends BaseLocatable
implements BeanFactory {
    private Log _log;
    private ErrorHandler _errorHandler;
    private Class _vendType;
    private Map _contributions = new HashMap();
    private Map _cache = new HashMap();
    private boolean _defaultCacheable;
    static /* synthetic */ Class class$java$lang$String;

    public BeanFactoryImpl(Log log, ErrorHandler errorHandler, Class clazz, List list, boolean bl) {
        this._log = log;
        this._errorHandler = errorHandler;
        this._vendType = clazz;
        this._defaultCacheable = bl;
        this.processContributions(list);
    }

    private void processContributions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BeanFactoryContribution beanFactoryContribution = (BeanFactoryContribution)((Object)iterator.next());
            Class clazz = beanFactoryContribution.getBeanClass();
            if (clazz.isInterface() || clazz.isArray() || clazz.isPrimitive()) {
                this._errorHandler.error(this._log, FactoryMessages.invalidContributionClass(beanFactoryContribution), beanFactoryContribution.getLocation(), null);
                continue;
            }
            if (!this._vendType.isAssignableFrom(clazz)) {
                this._errorHandler.error(this._log, FactoryMessages.wrongContributionType(beanFactoryContribution, this._vendType), beanFactoryContribution.getLocation(), null);
                continue;
            }
            String string = beanFactoryContribution.getName();
            BeanFactoryContribution beanFactoryContribution2 = (BeanFactoryContribution)((Object)this._contributions.get(string));
            if (beanFactoryContribution2 != null) {
                this._errorHandler.error(this._log, FactoryMessages.dupeContribution(beanFactoryContribution2), beanFactoryContribution2.getLocation(), null);
                continue;
            }
            this._contributions.put(string, beanFactoryContribution);
        }
    }

    public synchronized Object get(String string) {
        Object object = this._cache.get(string);
        if (object == null) {
            object = this.create(string);
        }
        return object;
    }

    private Object create(String string) {
        int n = string.indexOf(44);
        String string2 = n < 0 ? string.trim() : string.substring(0, n);
        String string3 = n < 0 ? null : string.substring(n + 1).trim();
        BeanFactoryContribution beanFactoryContribution = (BeanFactoryContribution)((Object)this._contributions.get(string2));
        if (beanFactoryContribution == null) {
            throw new ApplicationRuntimeException(FactoryMessages.unknownContribution(string2));
        }
        Object object = this.construct(beanFactoryContribution, string3);
        if (beanFactoryContribution.getStoreResultInCache(this._defaultCacheable)) {
            this._cache.put(string, object);
        }
        return object;
    }

    private Object construct(BeanFactoryContribution beanFactoryContribution, String string) {
        Class clazz = beanFactoryContribution.getBeanClass();
        try {
            if (HiveMind.isBlank((String)string)) {
                return clazz.newInstance();
            }
            Constructor constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BeanFactoryImpl.class$("java.lang.String")) : class$java$lang$String);
            return constructor.newInstance(string);
        }
        catch (Exception exception) {
            throw new ApplicationRuntimeException(FactoryMessages.unableToInstantiate(clazz, exception), beanFactoryContribution.getLocation(), (Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

