/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.management.impl;

import java.beans.PropertyEditorManager;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.internal.ServicePoint;
import org.apache.hivemind.management.ObjectNameBuilder;
import org.apache.hivemind.util.IdUtils;

public class ObjectNameBuilderImpl
implements ObjectNameBuilder {
    private String _domain = "hivemind";
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$org$apache$hivemind$management$impl$ObjectNameEditor;

    protected ObjectName createObjectNameInstance(String name) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new ApplicationRuntimeException((Throwable)e);
        }
        return objectName;
    }

    public ObjectName createObjectName(String[] keys, String[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays keys and values must have same length");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._domain + ':');
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(keys[i]);
            sb.append("=");
            sb.append(values[i]);
        }
        return this.createObjectNameInstance(sb.toString());
    }

    public ObjectName createObjectName(String qualifiedId, String type) {
        String moduleId = IdUtils.extractModule((String)qualifiedId);
        if (moduleId == null) {
            moduleId = "(default package)";
        }
        String id = IdUtils.stripModule((String)qualifiedId);
        return this.createObjectName(moduleId, id, type);
    }

    public ObjectName createObjectName(String moduleId, String id, String type) {
        return this.createObjectName(new String[]{"module", "type", "id"}, new String[]{moduleId, type, id});
    }

    public ObjectName createServiceObjectName(ServicePoint servicePoint) {
        return this.createObjectName(servicePoint.getExtensionPointId(), "service");
    }

    public ObjectName createServiceDecoratorName(ServicePoint servicePoint, String decoratorType) {
        return this.createObjectName(new String[]{"module", "type", "id", "decorator"}, new String[]{servicePoint.getModule().getModuleId(), "service", IdUtils.stripModule((String)servicePoint.getExtensionPointId()), decoratorType});
    }

    public String getDomain() {
        return this._domain;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PropertyEditorManager.registerEditor(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ObjectNameBuilderImpl.class$("javax.management.ObjectName")) : class$javax$management$ObjectName, class$org$apache$hivemind$management$impl$ObjectNameEditor == null ? (class$org$apache$hivemind$management$impl$ObjectNameEditor = ObjectNameBuilderImpl.class$("org.apache.hivemind.management.impl.ObjectNameEditor")) : class$org$apache$hivemind$management$impl$ObjectNameEditor);
    }
}

