/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.management.log4j;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.apache.hivemind.management.mbeans.AbstractDynamicMBean;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.jmx.AppenderDynamicMBean;

public class LoggerMBean
extends AbstractDynamicMBean
implements NotificationListener {
    private MBeanConstructorInfo[] _constructors = new MBeanConstructorInfo[0];
    private MBeanOperationInfo[] _operations = new MBeanOperationInfo[1];
    private List _attributes = new ArrayList();
    private String _className = this.getClass().getName();
    private String _description = "This MBean acts as a management facade for a org.apache.log4j.Logger instance.";
    private static Logger _log = Logger.getLogger((Class)(class$org$apache$hivemind$management$log4j$LoggerMBean == null ? (class$org$apache$hivemind$management$log4j$LoggerMBean = LoggerMBean.class$("org.apache.hivemind.management.log4j.LoggerMBean")) : class$org$apache$hivemind$management$log4j$LoggerMBean));
    private Logger _logger;
    static /* synthetic */ Class class$org$apache$hivemind$management$log4j$LoggerMBean;
    static /* synthetic */ Class class$org$apache$log4j$Appender;

    public LoggerMBean(Logger logger) {
        this._logger = logger;
        this.buildDynamicMBeanInfo();
    }

    public void handleNotification(Notification notification, Object handback) {
        _log.debug((Object)("Received notification: " + notification.getType()));
        this.registerAppenderMBean((Appender)notification.getUserData());
    }

    private void buildDynamicMBeanInfo() {
        this._attributes.add(new MBeanAttributeInfo("name", "java.lang.String", "The name of this Logger.", true, false, false));
        this._attributes.add(new MBeanAttributeInfo("priority", "java.lang.String", "The priority of this logger.", true, true, false));
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("class_name", "java.lang.String", "add an appender to this logger"), new MBeanParameterInfo("appender_name", "java.lang.String", "name of the appender")};
        this._operations[0] = new MBeanOperationInfo("addAppender", "addAppender(): add an appender", params, "void", 1);
    }

    protected Logger getLogger() {
        return this._logger;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] attribs = new MBeanAttributeInfo[this._attributes.size()];
        this._attributes.toArray(attribs);
        MBeanInfo mb = new MBeanInfo(this._className, this._description, attribs, this._constructors, this._operations, new MBeanNotificationInfo[0]);
        return mb;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName.equals("addAppender")) {
            this.addAppender((String)params[0], (String)params[1]);
            return "Hello world.";
        }
        return null;
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this._className + " with null attribute name");
        }
        if (attributeName.equals("name")) {
            return this._logger.getName();
        }
        if (attributeName.equals("priority")) {
            Level l = this._logger.getLevel();
            if (l == null) {
                return null;
            }
            return l.toString();
        }
        if (attributeName.startsWith("appender=")) {
            try {
                return new ObjectName("log4j:" + attributeName);
            }
            catch (Exception e) {
                _log.error((Object)("Could not create ObjectName" + attributeName));
            }
        }
        throw new AttributeNotFoundException("Cannot find " + attributeName + " attribute in " + this._className);
    }

    void addAppender(String appenderClass, String appenderName) {
        _log.debug((Object)("addAppender called with " + appenderClass + ", " + appenderName));
        Appender appender = (Appender)OptionConverter.instantiateByClassName((String)appenderClass, (Class)(class$org$apache$log4j$Appender == null ? (class$org$apache$log4j$Appender = LoggerMBean.class$("org.apache.log4j.Appender")) : class$org$apache$log4j$Appender), null);
        appender.setName(appenderName);
        this._logger.addAppender(appender);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Cannot invoke a setter of " + this._className + " with null attribute");
        }
        String name = attribute.getName();
        Object value = attribute.getValue();
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke the setter of " + this._className + " with null attribute name");
        }
        if (name.equals("priority")) {
            if (value instanceof String) {
                String s = (String)value;
                Object p = this._logger.getLevel();
                p = s.equalsIgnoreCase("NULL") ? null : OptionConverter.toLevel((String)s, (Level)p);
                this._logger.setLevel(p);
            }
        } else {
            throw new AttributeNotFoundException("Attribute " + name + " not found in " + this.getClass().getName());
        }
    }

    void appenderMBeanRegistration() {
        Enumeration enumeration = this._logger.getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender appender = (Appender)enumeration.nextElement();
            this.registerAppenderMBean(appender);
        }
    }

    void registerAppenderMBean(Appender appender) {
        String name = appender.getName();
        _log.debug((Object)("Adding AppenderMBean for appender named " + name));
        ObjectName objectName = null;
        try {
            AppenderDynamicMBean appenderMBean = new AppenderDynamicMBean(appender);
            objectName = new ObjectName("log4j", "appender", name);
            this.getMBeanServer().registerMBean(appenderMBean, objectName);
            this._attributes.add(new MBeanAttributeInfo("appender=" + name, "javax.management.ObjectName", "The " + name + " appender.", true, true, false));
        }
        catch (Exception e) {
            _log.error((Object)("Could not add appenderMBean for [" + name + "]."), (Throwable)e);
        }
    }

    public void postRegister(Boolean registrationDone) {
        this.appenderMBeanRegistration();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

