/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.management.log4j;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import mx4j.AbstractDynamicMBean;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.management.ObjectNameBuilder;
import org.apache.hivemind.management.log4j.LogManagement;
import org.apache.hivemind.management.log4j.LoggerContribution;
import org.apache.hivemind.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.jmx.LoggerDynamicMBean;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class LogManagementMBean
extends AbstractDynamicMBean
implements MBeanRegistration,
LogManagement {
    private static final String OBJECT_NAME_TYPE = "logger";
    private static final char WILDCARD = '*';
    private static Logger logger = Logger.getLogger((Class)(class$org$apache$hivemind$management$log4j$LogManagementMBean == null ? (class$org$apache$hivemind$management$log4j$LogManagementMBean = LogManagementMBean.class$("org.apache.hivemind.management.log4j.LogManagementMBean")) : class$org$apache$hivemind$management$log4j$LogManagementMBean));
    private ObjectNameBuilder _objectNameBuilder;
    private LoggerRepository _loggerRepository;
    private MBeanServer _mbeanserver;
    private List _loggerContributions;
    static /* synthetic */ Class class$org$apache$hivemind$management$log4j$LogManagementMBean;
    static /* synthetic */ Class class$java$lang$String;

    public LogManagementMBean(ObjectNameBuilder objectNameBuilder, List loggerContributions) {
        this._objectNameBuilder = objectNameBuilder;
        this._loggerRepository = LogManager.getLoggerRepository();
        this._loggerContributions = loggerContributions;
    }

    protected MBeanAttributeInfo[] createMBeanAttributeInfo() {
        return new MBeanAttributeInfo[]{new MBeanAttributeInfo("Threshold", (class$java$lang$String == null ? (class$java$lang$String = LogManagementMBean.class$("java.lang.String")) : class$java$lang$String).getName(), "The \"threshold\" state of the logger hierarchy.", true, true, false)};
    }

    protected MBeanOperationInfo[] createMBeanOperationInfo() {
        MBeanParameterInfo[] parameterInfo = new MBeanParameterInfo[]{new MBeanParameterInfo("loggerPattern", "java.lang.String", "Name of the Logger. Use * as wildcard")};
        return new MBeanOperationInfo[]{new MBeanOperationInfo("addLoggerMBean", "Adds a MBean for a single Logger or a group of Loggers", parameterInfo, "void", 1)};
    }

    public ObjectName preRegister(MBeanServer mbeanserver, ObjectName objectname) {
        this._mbeanserver = mbeanserver;
        return objectname;
    }

    public void postRegister(Boolean registrationDone) {
        this.addConfiguredLoggerMBeans();
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public String getThreshold() {
        return this._loggerRepository.getThreshold().toString();
    }

    public void setThreshold(String threshold) {
        OptionConverter.toLevel((String)threshold, (Level)this._loggerRepository.getThreshold());
        this._loggerRepository.setThreshold(threshold);
    }

    public void addLoggerMBean(String loggerPattern) {
        boolean hasWildcard;
        boolean bl = hasWildcard = loggerPattern.indexOf(42) >= 0;
        if (hasWildcard) {
            this.addLoggerMBeansForPattern(loggerPattern);
        } else {
            Logger log = LogManager.getLogger((String)loggerPattern);
            this.addLoggerMBean(log);
        }
    }

    protected ObjectName addLoggerMBean(Logger log) {
        String name = log.getName();
        ObjectName objectname = null;
        try {
            LoggerDynamicMBean loggerMBean = new LoggerDynamicMBean(log);
            objectname = this.getObjectNameBuilder().createObjectName(name, OBJECT_NAME_TYPE);
            this._mbeanserver.registerMBean(loggerMBean, objectname);
        }
        catch (InstanceAlreadyExistsException exception) {
            log.warn((Object)("MBean for Logger " + log.getName() + " already exists"));
        }
        catch (JMException exception) {
            throw new ApplicationRuntimeException((Throwable)exception);
        }
        return objectname;
    }

    protected void addConfiguredLoggerMBeans() {
        Iterator iterContributions = this._loggerContributions.iterator();
        while (iterContributions.hasNext()) {
            LoggerContribution contribution = (LoggerContribution)((Object)iterContributions.next());
            String loggerPattern = contribution.getLoggerPattern();
            this.addLoggerMBeansForPattern(loggerPattern);
        }
    }

    protected void addLoggerMBeansForPattern(String loggerPattern) {
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger log = (Logger)loggers.nextElement();
            if (!this.isMatch(log.getName(), loggerPattern)) continue;
            this.addLoggerMBean(log);
        }
    }

    public ObjectNameBuilder getObjectNameBuilder() {
        return this._objectNameBuilder;
    }

    protected boolean isMatch(String loggerName, String loggerPattern) {
        Pattern compiled;
        String realLoggerPattern = StringUtils.replace((String)loggerPattern, (String)"*", (String)".*");
        Perl5Compiler compiler = new Perl5Compiler();
        Perl5Matcher matcher = new Perl5Matcher();
        try {
            compiled = compiler.compile(realLoggerPattern);
        }
        catch (MalformedPatternException e) {
            throw new ApplicationRuntimeException("Malformed Logger Pattern:" + realLoggerPattern);
        }
        return matcher.matches(loggerName, compiled);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

