/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.context.Context;
import org.hibernate.Hibernate;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.MetaAttributeHelper;
import org.hibernate.tool.hbm2x.StringUtils;
import org.hibernate.type.Type;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.StringHelper;

public class Cfg2JavaTool {
    private static final Log log = LogFactory.getLog((Class)Cfg2JavaTool.class);
    private boolean globalPreferRawTypes;
    private static final Map primitives = new HashMap();
    private static Set nonPrimitiveTypes;
    static final Set PRIMITIVES;
    static /* synthetic */ Class class$org$hibernate$type$Type;

    public Cfg2JavaTool() {
        this(false);
    }

    public Cfg2JavaTool(boolean preferRawTypes) {
        this.globalPreferRawTypes = preferRawTypes;
    }

    public String stripPackage(String type, PersistentClass clazz) {
        String packageName = this.getPackageName(clazz);
        return this.stripPackage(type, packageName);
    }

    public String stripPackage(String type, Component clazz) {
        String packageName = this.getPackageName(clazz);
        return this.stripPackage(type, packageName);
    }

    public boolean getPreferRawTypes() {
        return false;
    }

    private String stripPackage(String type, String packageName) {
        String pkg = StringHelper.qualifier((String)type);
        if (pkg.equals(packageName) || pkg.equals("java.lang") || pkg.equals("java.util")) {
            return StringHelper.unqualify((String)type);
        }
        return type;
    }

    public String getPackageDeclaration(PersistentClass clazz) {
        String pkgName = this.getPackageName(clazz);
        return this.getPackageDeclaration(pkgName);
    }

    private String getPackageDeclaration(String pkgName) {
        if (pkgName != null && pkgName.trim().length() != 0) {
            return "package " + pkgName + ";";
        }
        return "// default package";
    }

    public String getPackageDeclaration(Component clazz) {
        String pkgName = this.getPackageName(clazz);
        return this.getPackageDeclaration(pkgName);
    }

    public String getPackageName(PersistentClass classMapping) {
        String generatedClass = this.getMetaAsString((MetaAttributable)classMapping, "generated-class").trim();
        if (StringHelper.isEmpty((String)generatedClass)) {
            generatedClass = classMapping.getClassName();
        }
        return StringHelper.qualifier((String)generatedClass);
    }

    public String getPackageName(Component classMapping) {
        String generatedClass = this.getMetaAsString((MetaAttributable)classMapping, "generated-class").trim();
        if (StringHelper.isEmpty((String)generatedClass)) {
            generatedClass = classMapping.getComponentClassName();
        }
        return StringHelper.qualifier((String)classMapping.getComponentClassName());
    }

    public String getMetaAsString(MetaAttributable pc, String attribute) {
        MetaAttribute c = pc.getMetaAttribute(attribute);
        return MetaAttributeHelper.getMetaAsString(c);
    }

    public boolean hasMetaAttribute(MetaAttributable pc, String attribute) {
        return pc.getMetaAttribute(attribute) != null;
    }

    public String getMetaAsString(MetaAttributable pc, String attribute, String seperator) {
        return MetaAttributeHelper.getMetaAsString(pc.getMetaAttribute(attribute), seperator);
    }

    public boolean getMetaAsBool(MetaAttributable property, String attribute) {
        return this.getMetaAsBool(property, attribute, false);
    }

    public boolean getMetaAsBool(MetaAttributable pc, String attribute, boolean defaultValue) {
        return MetaAttributeHelper.getMetaAsBool(pc.getMetaAttribute(attribute), defaultValue);
    }

    public String getFieldJavaDoc(Property property, int indent) {
        MetaAttribute c = property.getMetaAttribute("field-description");
        if (c == null) {
            return this.toJavaDoc("", indent);
        }
        return this.toJavaDoc(this.getMetaAsString((MetaAttributable)property, "field-description"), indent);
    }

    public String getClassJavaDoc(MetaAttributable classMapping, String fallback, int indent) {
        MetaAttribute c = classMapping.getMetaAttribute("class-description");
        if (c == null) {
            return this.toJavaDoc(fallback, indent);
        }
        return this.toJavaDoc(this.getMetaAsString(classMapping, "class-description"), indent);
    }

    public String toJavaDoc(String string, int indent) {
        StringBuffer result = new StringBuffer();
        if (string != null) {
            String[] lines = StringUtils.split(string, "\n\r\f");
            for (int i = 0; i < lines.length; ++i) {
                String docline = " * " + lines[i];
                if (i < lines.length - 1) {
                    docline = docline + "\n";
                }
                result.append(StringUtils.leftPad(docline, docline.length() + indent));
            }
        }
        return result.toString();
    }

    public String getClassModifiers(MetaAttributable pc) {
        String classModifiers = null;
        if (pc.getMetaAttribute("scope-class") != null) {
            classModifiers = this.getMetaAsString(pc, "scope-class").trim();
        }
        if (pc.getMetaAttribute("class-modifier") != null) {
            classModifiers = this.getMetaAsString(pc, "class-modifier").trim();
        }
        return classModifiers == null ? "public" : classModifiers;
    }

    public String getDeclarationType(MetaAttributable pc) {
        boolean isInterface = this.isInterface(pc);
        if (isInterface) {
            return "interface";
        }
        return "class";
    }

    public boolean isInterface(MetaAttributable pc) {
        return this.getMetaAsBool(pc, "interface");
    }

    public String getDeclarationName(PersistentClass pc) {
        return StringHelper.unqualify((String)this.getQualifiedDeclarationName(pc));
    }

    public String getDeclarationName(Component pc) {
        return StringHelper.unqualify((String)this.getQualifiedDeclarationName(pc));
    }

    public String getQualifiedDeclarationName(PersistentClass pc) {
        String generatedName = this.getMetaAsString((MetaAttributable)pc, "generated-class");
        if (generatedName == null || generatedName.trim().length() == 0) {
            generatedName = pc.getClassName();
        }
        return generatedName;
    }

    public String getQualifiedDeclarationName(Component component) {
        String generatedName = this.getMetaAsString((MetaAttributable)component, "generated-class");
        if (generatedName == null || generatedName.trim().length() == 0) {
            generatedName = component.getComponentClassName();
        }
        generatedName = generatedName.replace('$', '.');
        String qualifier = StringHelper.qualifier((String)component.getComponentClassName());
        if ("".equals(qualifier)) {
            return qualifier + "." + generatedName;
        }
        return generatedName;
    }

    public String getExtendsDeclaration(PersistentClass pc) {
        String extendz = this.getExtends(pc);
        if (extendz == null || extendz.trim().length() == 0) {
            return "";
        }
        return "extends " + extendz;
    }

    public String getExtendsDeclaration(Component pc) {
        String extendz = this.getExtends(pc);
        if (extendz == null || extendz.trim().length() == 0) {
            return "";
        }
        return "extends " + extendz;
    }

    public String getImplementsDeclaration(PersistentClass pc) {
        String implementz = this.getImplements(pc);
        if (implementz == null || implementz.trim().length() == 0) {
            return "";
        }
        return "implements " + implementz;
    }

    public String getImplementsDeclaration(Component pc) {
        String implementz = this.getImplements(pc);
        if (implementz == null || implementz.trim().length() == 0) {
            return "";
        }
        return "implements " + implementz;
    }

    public String getExtends(PersistentClass pc) {
        String extendz = "";
        if (this.isInterface((MetaAttributable)pc)) {
            if (pc.getSuperclass() != null) {
                extendz = pc.getSuperclass().getClassName();
            }
            if (pc.getMetaAttribute("extends") != null) {
                if (!"".equals(extendz)) {
                    extendz = extendz + ",";
                }
                extendz = extendz + this.getMetaAsString((MetaAttributable)pc, "extends", ",");
            }
        } else if (pc.getSuperclass() != null) {
            if (!this.isInterface((MetaAttributable)pc.getSuperclass())) {
                extendz = pc.getSuperclass().getClassName();
            }
        } else if (pc.getMetaAttribute("extends") != null) {
            extendz = this.getMetaAsString((MetaAttributable)pc, "extends", ",");
        }
        return "".equals(extendz) ? null : extendz;
    }

    public String getExtends(Component pc) {
        String extendz = "";
        if (this.isInterface((MetaAttributable)pc)) {
            if (pc.getMetaAttribute("extends") != null) {
                if (!"".equals(extendz)) {
                    extendz = extendz + ",";
                }
                extendz = extendz + this.getMetaAsString((MetaAttributable)pc, "extends", ",");
            }
        } else if (pc.getMetaAttribute("extends") != null) {
            extendz = this.getMetaAsString((MetaAttributable)pc, "extends", ",");
        }
        return "".equals(extendz) ? null : extendz;
    }

    public String getImplements(PersistentClass pc) {
        ArrayList<String> interfaces = new ArrayList<String>();
        if (pc.getProxyInterfaceName() != null && !pc.getProxyInterfaceName().equals(pc.getClassName())) {
            interfaces.add(pc.getProxyInterfaceName());
        }
        if (!this.isInterface((MetaAttributable)pc)) {
            if (pc.getSuperclass() != null && this.isInterface((MetaAttributable)pc.getSuperclass())) {
                interfaces.add(pc.getSuperclass().getClassName());
            }
            if (pc.getMetaAttribute("implements") != null) {
                interfaces.addAll(pc.getMetaAttribute("implements").getValues());
            }
            interfaces.add(Serializable.class.getName());
        }
        if (interfaces.size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            Iterator iter = interfaces.iterator();
            while (iter.hasNext()) {
                sbuf.append(iter.next());
                if (!iter.hasNext()) continue;
                sbuf.append(",");
            }
            return sbuf.toString();
        }
        return null;
    }

    public String getImplements(Component pc) {
        ArrayList<String> interfaces = new ArrayList<String>();
        if (!this.isInterface((MetaAttributable)pc)) {
            if (pc.getMetaAttribute("implements") != null) {
                interfaces.addAll(pc.getMetaAttribute("implements").getValues());
            }
            interfaces.add(Serializable.class.getName());
        }
        if (interfaces.size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            Iterator iter = interfaces.iterator();
            while (iter.hasNext()) {
                sbuf.append(iter.next());
                if (!iter.hasNext()) continue;
                sbuf.append(",");
            }
            return sbuf.toString();
        }
        return null;
    }

    private String toName(Class c) {
        if (c.isArray()) {
            Class<?> a = c.getComponentType();
            return a.getName() + "[]";
        }
        return c.getName();
    }

    public String getJavaTypeName(Property p) {
        return this.getJavaTypeName(p, false);
    }

    public String getJavaTypeName(Property p, boolean useGenerics) {
        String overrideType = this.getMetaAsString((MetaAttributable)p, "property-type");
        if (!StringHelper.isEmpty((String)overrideType)) {
            return overrideType;
        }
        String rawType = this.getRawTypeName(p, useGenerics, this.globalPreferRawTypes);
        rawType = rawType.replace('$', '.');
        return rawType;
    }

    boolean isNonPrimitiveTypeName(String typeName) {
        if (nonPrimitiveTypes == null) {
            nonPrimitiveTypes = new HashSet();
            Field[] fields = Hibernate.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!Modifier.isStatic(field.getModifiers()) || !(class$org$hibernate$type$Type == null ? Cfg2JavaTool.class$("org.hibernate.type.Type") : class$org$hibernate$type$Type).isAssignableFrom(field.getType())) continue;
                try {
                    Type type = (Type)field.get(class$org$hibernate$Hibernate == null ? Cfg2JavaTool.class$("org.hibernate.Hibernate") : class$org$hibernate$Hibernate);
                    if (primitives.containsKey(type.getName())) continue;
                    nonPrimitiveTypes.add(type.getName());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ExporterException("Could not create list of basic hibernate types", e);
                }
                catch (IllegalAccessException e) {
                    throw new ExporterException("Could not create list of basic hibernate types", e);
                }
            }
        }
        return nonPrimitiveTypes.contains(typeName);
    }

    private String getRawTypeName(Property p, boolean useGenerics, boolean preferRawTypeNames) {
        Value value = null;
        Object t = null;
        try {
            String typename;
            value = p.getValue();
            if (value instanceof Array) {
                Array a = (Array)value;
                if (a.isPrimitiveArray()) {
                    return this.toName(value.getType().getReturnedClass());
                }
                return ((Array)value).getElementClassName() + "[]";
            }
            if (value instanceof Component) {
                return ((Component)value).getComponentClassName();
            }
            if (value instanceof ToOne) {
                return ((ToOne)value).getReferencedEntityName();
            }
            if (useGenerics && value instanceof Collection) {
                Collection collection = (Collection)value;
                OneToMany oneToMany = (OneToMany)collection.getElement();
                String entityType = oneToMany.getAssociatedClass().getClassName();
                return this.toName(p.getType().getReturnedClass()) + "<" + entityType + ">";
            }
            if (preferRawTypeNames && value.isSimpleValue() && !this.isNonPrimitiveTypeName(typename = ((SimpleValue)value).getTypeName())) {
                return ((SimpleValue)value).getTypeName();
            }
            return this.toName(value.getType().getReturnedClass());
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Could not resolve type without exception for " + p + " Value: " + value + " Type: " + t;
            if (value != null && value.isSimpleValue()) {
                String typename = ((SimpleValue)value).getTypeName();
                log.warn((Object)(msg + ". Falling back to typename: " + typename));
                return typename;
            }
            e.printStackTrace();
            throw new ExporterException(msg, e);
        }
    }

    public String asParameterList(Iterator fields) {
        StringBuffer buf = new StringBuffer();
        while (fields.hasNext()) {
            Property field = (Property)fields.next();
            buf.append(this.getJavaTypeName(field) + " " + field.getName());
            if (!fields.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String asArgumentList(Iterator fields) {
        StringBuffer buf = new StringBuffer();
        while (fields.hasNext()) {
            Property field = (Property)fields.next();
            buf.append(field.getName());
            if (!fields.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String asParameterList(List fields) {
        return this.asParameterList(fields.iterator());
    }

    public String asArgumentList(List fields) {
        return this.asArgumentList(fields.iterator());
    }

    public List getPropertyClosureForFullConstructor(PersistentClass pc) {
        List result = this.getPropertyClosureForSuperclassFullConstructor(pc);
        result.addAll(this.getPropertiesForFullConstructor(pc));
        return result;
    }

    public List getPropertiesForFullConstructor(PersistentClass pc) {
        ArrayList<Property> result = new ArrayList<Property>();
        if (pc.getSuperclass() == null && pc.hasIdentifierProperty()) {
            result.add(pc.getIdentifierProperty());
        }
        Iterator myFields = pc.getPropertyIterator();
        while (myFields.hasNext()) {
            Property field = (Property)myFields.next();
            result.add(field);
        }
        return result;
    }

    public List getPropertyClosureForSuperclassFullConstructor(PersistentClass pc) {
        ArrayList result = new ArrayList();
        if (pc.getSuperclass() != null) {
            result.addAll(this.getPropertyClosureForSuperclassFullConstructor(pc.getSuperclass()));
            result.addAll(this.getPropertiesForFullConstructor(pc.getSuperclass()));
        }
        return result;
    }

    public Iterator getAllPropertiesIterator(PersistentClass pc) {
        ArrayList<Property> properties = new ArrayList<Property>();
        ArrayList<Iterator> iterators = new ArrayList<Iterator>();
        if (pc.getSuperclass() == null) {
            if (pc.hasIdentifierProperty()) {
                properties.add(pc.getIdentifierProperty());
            } else if (pc.hasEmbeddedIdentifier()) {
                Component embeddedComponent = (Component)pc.getIdentifier();
                iterators.add(embeddedComponent.getPropertyIterator());
            }
        }
        iterators.add(properties.iterator());
        iterators.add(pc.getPropertyIterator());
        Iterator[] it = iterators.toArray(new Iterator[iterators.size()]);
        return new JoinedIterator(it);
    }

    public Iterator getAllPropertiesIterator(Component pc) {
        return pc.getPropertyIterator();
    }

    public String getFieldModifiers(Property property) {
        return this.getModifiers(property, "scope-field", "private");
    }

    public String getPropertyGetModifiers(Property property) {
        return this.getModifiers(property, "scope-get", "public");
    }

    public String getPropertySetModifiers(Property property) {
        return this.getModifiers(property, "scope-set", "public");
    }

    private String getModifiers(Property property, String modifiername, String defaultModifiers) {
        MetaAttribute override = property.getMetaAttribute(modifiername);
        if (override != null) {
            return MetaAttributeHelper.getMetaAsString(override);
        }
        return defaultModifiers;
    }

    public String getGetterSignature(Property p) {
        String prefix = this.getJavaTypeName(p).equals("boolean") ? "is" : "get";
        return prefix + this.beanCapitalize(p.getName());
    }

    public String getPropertyName(Property p) {
        return this.beanCapitalize(p.getName());
    }

    private String beanCapitalize(String fieldname) {
        if (fieldname == null || fieldname.length() == 0) {
            return fieldname;
        }
        if (fieldname.length() > 1 && Character.isUpperCase(fieldname.charAt(1)) && Character.isUpperCase(fieldname.charAt(0))) {
            return fieldname;
        }
        char[] chars = fieldname.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public boolean isComponent(Property property) {
        Value value = property.getValue();
        return value != null && value instanceof Component;
    }

    public boolean isComponent(Component c) {
        return true;
    }

    public boolean isComponent(PersistentClass c) {
        return false;
    }

    public boolean needsEqualsHashCode(Component c) {
        Iterator iter = this.getAllPropertiesIterator(c);
        return this.needsEqualsHashCode(iter);
    }

    private boolean needsEqualsHashCode(Iterator iter) {
        while (iter.hasNext()) {
            Property element = (Property)iter.next();
            if (!this.getMetaAsBool((MetaAttributable)element, "use-in-equals")) continue;
            return true;
        }
        return false;
    }

    public boolean needsEqualsHashCode(PersistentClass c) {
        Iterator iter = this.getAllPropertiesIterator(c);
        return this.needsEqualsHashCode(iter);
    }

    public String generateEquals(PersistentClass c, String thisName, String otherName) {
        Iterator allPropertiesIterator = this.getAllPropertiesIterator(c);
        return this.generateEquals(thisName, otherName, allPropertiesIterator);
    }

    public String generateEquals(Component c, String thisName, String otherName) {
        Iterator allPropertiesIterator = this.getAllPropertiesIterator(c);
        return this.generateEquals(thisName, otherName, allPropertiesIterator);
    }

    public String generateHashCode(Property property, String result, String thisName) {
        StringBuffer buf = new StringBuffer();
        if (this.getMetaAsBool((MetaAttributable)property, "use-in-equals")) {
            String hashCode = "";
            String cast = "";
            if (!PRIMITIVES.contains(this.getJavaTypeName(property))) {
                hashCode = hashCode + ".hashCode()";
            } else {
                cast = "(int) ";
            }
            buf.append(result).append(" = 37 * ").append(result).append(" + ");
            if (property.isOptional()) {
                buf.append("( ").append(this.getGetterSignature(property)).append("() == null ? 0 : ");
            }
            buf.append(cast).append(thisName).append(".").append(this.getGetterSignature(property)).append("()").append(hashCode);
            if (property.isOptional()) {
                buf.append(" )");
            }
        }
        return buf.toString();
    }

    private String generateEquals(String thisName, String otherName, Iterator allPropertiesIterator) {
        StringBuffer buf = new StringBuffer();
        while (allPropertiesIterator.hasNext()) {
            Property property = (Property)allPropertiesIterator.next();
            if (!this.getMetaAsBool((MetaAttributable)property, "use-in-equals")) continue;
            if (buf.length() > 0) {
                buf.append("\n && ");
            }
            buf.append(this.generateEquals(this.getJavaTypeName(property), thisName + "." + this.getGetterSignature(property) + "()", otherName + "." + this.getGetterSignature(property) + "()"));
        }
        if (buf.length() == 0) {
            return "false";
        }
        return buf.toString();
    }

    private String generateEquals(String typeName, String lh, String rh) {
        if (PRIMITIVES.contains(typeName)) {
            return "(" + lh + "==" + rh + ")";
        }
        return "(" + lh + "==" + rh + ") || ( " + lh + "!=null && " + rh + "!=null && " + lh + ".equals(" + rh + ") )";
    }

    public String getExtraCode(PersistentClass clazz) {
        return this.getMetaAsString((MetaAttributable)clazz, "class-code", "\n");
    }

    public String getExtraCode(Component clazz) {
        return this.getMetaAsString((MetaAttributable)clazz, "class-code", "\n");
    }

    public void addExtraImports(PersistentClass pc, Context ctx) {
        MetaAttribute metaAttribute = pc.getMetaAttribute("extra-import");
        if (metaAttribute != null) {
            this.addImports(ctx, metaAttribute.getValues());
        } else {
            ctx.put("classimports", (Object)"");
        }
    }

    public void addExtraImports(Component pc, Context ctx) {
        MetaAttribute metaAttribute = pc.getMetaAttribute("extra-import");
        if (metaAttribute != null) {
            this.addImports(ctx, metaAttribute.getValues());
        }
    }

    private void addImports(Context ctx, List imports) {
        StringBuffer buf = new StringBuffer();
        if (imports != null) {
            Iterator it = imports.iterator();
            while (it.hasNext()) {
                String cname = it.next().toString();
                buf.append("import " + cname + ";\n");
            }
        }
        ctx.put("classimports", (Object)buf.toString());
    }

    static {
        primitives.put("char", "Character");
        primitives.put("byte", "Byte");
        primitives.put("short", "Short");
        primitives.put("int", "Integer");
        primitives.put("long", "Long");
        primitives.put("boolean", "Boolean");
        primitives.put("float", "Float");
        primitives.put("double", "Double");
        nonPrimitiveTypes = null;
        PRIMITIVES = new HashSet();
        PRIMITIVES.add("byte");
        PRIMITIVES.add("short");
        PRIMITIVES.add("int");
        PRIMITIVES.add("long");
        PRIMITIVES.add("float");
        PRIMITIVES.add("double");
        PRIMITIVES.add("char");
        PRIMITIVES.add("boolean");
    }
}

