/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.ant.AnnotationConfigurationTask;
import org.hibernate.tool.ant.Cfg2HbmGeneratorTask;
import org.hibernate.tool.ant.ConfigurationTask;
import org.hibernate.tool.ant.GeneratorTask;
import org.hibernate.tool.ant.Hbm2DDLGeneratorTask;
import org.hibernate.tool.ant.Hbm2DocGeneratorTask;
import org.hibernate.tool.ant.Hbm2JavaGeneratorTask;
import org.hibernate.tool.ant.JDBCConfigurationTask;

public class HibernateToolTask
extends Task {
    ConfigurationTask configurationTask;
    private File destDir;
    private List generators = new ArrayList();
    private Path classPath;
    private Path templatePath;

    private void checkConfiguration() {
        if (this.configurationTask != null) {
            throw new BuildException("Only a single configuration is allowed.");
        }
    }

    public ConfigurationTask createConfiguration() {
        this.checkConfiguration();
        this.configurationTask = new ConfigurationTask();
        return this.configurationTask;
    }

    public JDBCConfigurationTask createJDBCConfiguration() {
        this.checkConfiguration();
        this.configurationTask = new JDBCConfigurationTask();
        return (JDBCConfigurationTask)this.configurationTask;
    }

    public AnnotationConfigurationTask createAnnotationConfiguration() {
        this.checkConfiguration();
        this.configurationTask = new AnnotationConfigurationTask();
        return (AnnotationConfigurationTask)this.configurationTask;
    }

    public GeneratorTask createHbm2DDL() {
        Hbm2DDLGeneratorTask generator = new Hbm2DDLGeneratorTask(this);
        this.generators.add(generator);
        return generator;
    }

    public GeneratorTask createHbm2Java() {
        Hbm2JavaGeneratorTask generator = new Hbm2JavaGeneratorTask(this);
        this.generators.add(generator);
        return generator;
    }

    public GeneratorTask createCfg2Hbm() {
        Cfg2HbmGeneratorTask generator = new Cfg2HbmGeneratorTask(this);
        this.generators.add(generator);
        return generator;
    }

    public GeneratorTask createHbm2Doc() {
        Hbm2DocGeneratorTask generator = new Hbm2DocGeneratorTask(this);
        this.generators.add(generator);
        return generator;
    }

    public void setClasspath(Path s) {
        this.classPath = s;
    }

    public Path createClasspath() {
        this.classPath = new Path(this.getProject());
        return this.classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        this.log("Executing Hibernate Tool with a " + this.configurationTask.getDescription());
        this.validateParameters();
        Iterator iterator = this.generators.iterator();
        AntClassLoader loader = this.project.createClassLoader(this.classPath);
        try {
            loader.setParent(this.project.getCoreLoader());
            loader.setThreadContextLoader();
            int count = 1;
            while (iterator.hasNext()) {
                GeneratorTask generatorTask = (GeneratorTask)iterator.next();
                this.log(count++ + ". task: " + generatorTask.getName());
                generatorTask.execute();
            }
            Object var6_5 = null;
            if (loader == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (loader == null) throw throwable;
            loader.resetThreadContextLoader();
            loader.cleanup();
            throw throwable;
        }
        loader.resetThreadContextLoader();
        loader.cleanup();
    }

    private void validateParameters() {
        Iterator iterator = this.generators.iterator();
        while (iterator.hasNext()) {
            GeneratorTask generatorTask = (GeneratorTask)iterator.next();
            generatorTask.validateParameters();
        }
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public Configuration getConfiguration() {
        return this.configurationTask.getConfiguration();
    }

    public Path getTemplatePath() {
        if (this.templatePath == null) {
            this.templatePath = new Path(this.getProject());
        }
        return this.templatePath;
    }
}

