/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import org.hibernate.tool.ant.GeneratorTask;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2x.Exporter;

public class Hbm2DDLGeneratorTask
extends GeneratorTask {
    boolean exportToDatabase = true;
    boolean scriptToConsole = true;
    boolean schemaUpdate = false;
    String delimiter = ";";
    boolean drop = false;
    boolean create = true;
    String outputfileName = null;

    public Hbm2DDLGeneratorTask(HibernateToolTask parent) {
        super(parent);
    }

    public void execute() {
        if (this.schemaUpdate) {
            SchemaUpdate update = new SchemaUpdate(this.parent.getConfiguration());
            update.execute(this.scriptToConsole, this.exportToDatabase);
        } else {
            SchemaExport export = new SchemaExport(this.parent.getConfiguration());
            if (this.outputfileName != null) {
                export.setOutputFile(new File(this.getDestdir(), this.outputfileName).toString());
            }
            if (this.delimiter != null) {
                export.setDelimiter(this.delimiter);
            }
            if (this.drop) {
                export.drop(this.scriptToConsole, this.exportToDatabase);
            }
            if (this.create) {
                export.create(this.scriptToConsole, this.exportToDatabase);
            }
        }
    }

    public void setExport(boolean export) {
        this.exportToDatabase = export;
    }

    public void setUpdate(boolean update) {
        this.schemaUpdate = update;
    }

    public void setConsole(boolean console) {
        this.scriptToConsole = console;
    }

    public void setOutputFileName(String fileName) {
        this.outputfileName = fileName;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public String getName() {
        return "hbm2ddl (Generates database schema)";
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    protected Exporter createExporter() {
        throw new IllegalStateException("Should not call create exporter on hbm2ddl");
    }
}

