/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.hbm2x.Exporter;

public abstract class GeneratorTask {
    protected HibernateToolTask parent;
    File destdir;
    private Path templatePath;

    public GeneratorTask(HibernateToolTask parent) {
        this.parent = parent;
    }

    public void execute() {
        Exporter exporter = this.configureExporter(this.createExporter());
        exporter.start();
    }

    protected abstract Exporter createExporter();

    public File getDestdir() {
        if (this.destdir == null) {
            return this.parent.getDestDir();
        }
        return this.destdir;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setTemplatesPath(Path path) {
        this.templatePath = path;
    }

    public void validateParameters() {
        if (this.getDestdir() == null) {
            throw new BuildException("destdir must be set, either locally or on <hibernatetool>");
        }
    }

    protected Path getTemplatePath() {
        if (this.templatePath == null) {
            return this.parent.getTemplatePath();
        }
        return this.templatePath;
    }

    abstract String getName();

    protected Exporter configureExporter(Exporter exporter) {
        exporter.setConfiguration(this.parent.getConfiguration());
        exporter.setOutputDir(this.getDestdir());
        exporter.setTemplatePaths(this.getTemplatePath().list());
        return exporter;
    }
}

