/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

public class SQLTypeMapping
implements Comparable {
    public static final int UNKNOWN_LENGTH = Integer.MAX_VALUE;
    public static final int UNKNOWN_PRECISION = Integer.MAX_VALUE;
    public static final int UNKNOWN_SCALE = Integer.MAX_VALUE;
    private final int jdbcType;
    private int length = Integer.MAX_VALUE;
    private int precision = Integer.MAX_VALUE;
    private int scale = Integer.MAX_VALUE;
    private String hibernateType;

    public SQLTypeMapping(int jdbcType) {
        this.jdbcType = jdbcType;
    }

    public SQLTypeMapping(int sqlType, int length, int precision, int scale) {
        this.jdbcType = sqlType;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setHibernateType(String hibernateType) {
        this.hibernateType = hibernateType;
    }

    public int getJDBCType() {
        return this.jdbcType;
    }

    public String getHibernateType() {
        return this.hibernateType;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        return this.getJDBCType() + "l:" + this.getLength() + "p:" + this.getPrecision() + "s:" + this.getScale() + "ht:" + this.getHibernateType();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean match(int matchjdbctype, int matchlength, int matchprecision, int matchscale) {
        return !(matchjdbctype != this.jdbcType || matchlength != this.length && this.length != Integer.MAX_VALUE || matchprecision != this.precision && this.precision != Integer.MAX_VALUE || matchscale != this.scale && this.scale != Integer.MAX_VALUE);
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        SQLTypeMapping other = (SQLTypeMapping)o;
        if (this.jdbcType == other.jdbcType) {
            if (this.length == other.length) {
                if (this.precision == other.precision) {
                    return this.compare(this.scale, other.scale);
                }
                return this.compare(this.precision, other.precision);
            }
            return this.compare(this.length, other.length);
        }
        return this.compare(this.jdbcType, other.jdbcType);
    }

    private int compare(int value, int other) {
        if (value == other) {
            return 0;
        }
        if (value > other) {
            return 1;
        }
        if (value < other) {
            return -1;
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return (this.jdbcType + this.length + this.precision + this.scale) % 17;
    }
}

