/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.tool.hbm2java.ClassMapping;
import net.sf.hibernate.tool.hbm2java.ClassName;
import net.sf.hibernate.tool.hbm2java.FieldProperty;
import org.apache.commons.lang.StringUtils;

public class JavaTool {
    static /* synthetic */ Class class$java$io$Serializable;

    public String getPackageDeclaration(ClassMapping cm) {
        if (cm.getGeneratedPackageName() != null) {
            return "package " + cm.getGeneratedPackageName() + ";";
        }
        return "// default package";
    }

    public static String getTrueTypeName(FieldProperty field, Map class2classmap) {
        ClassMapping cmap;
        String name;
        String string = name = field.getClassType() != null ? field.getClassType().getFullyQualifiedName() : field.getFullyQualifiedTypeName();
        if (field.getMeta("property-type") != null) {
            name = field.getMetaAsString("property-type");
        }
        if ((cmap = (ClassMapping)class2classmap.get(name)) != null && cmap.getProxy() != null) {
            return cmap.getProxy();
        }
        return name;
    }

    public String getTrueTypeName(ClassName cn, Map class2classmap) {
        String name = cn.getFullyQualifiedName();
        ClassMapping cmap = (ClassMapping)class2classmap.get(name);
        if (cmap != null && cmap.getProxy() != null) {
            return cmap.getProxy();
        }
        return name;
    }

    public static String shortenType(String type, Set imports) {
        String result = type;
        if (imports.contains(type)) {
            result = type.substring(type.lastIndexOf(46) + 1);
        } else if (type.endsWith("[]")) {
            result = JavaTool.shortenType(type.substring(0, type.length() - 2), imports) + "[]";
        } else if (type.startsWith("java.lang.")) {
            result = type.substring("java.lang.".length());
        }
        return result;
    }

    public String toJavaDoc(String string, int indent) {
        StringBuffer result = new StringBuffer();
        if (string != null) {
            String[] lines = StringUtils.split((String)string, (String)"\n\r\f");
            for (int i = 0; i < lines.length; ++i) {
                String docline = " * " + lines[i] + "\n";
                result.append(StringUtils.leftPad((String)docline, (int)(docline.length() + indent)));
            }
        }
        return result.toString();
    }

    public boolean hasExtends(ClassMapping cmap) {
        return this.getExtends(cmap) != null;
    }

    public String getExtends(ClassMapping cmap) {
        String extendz = null;
        if (cmap.isInterface()) {
            if (cmap.getSuperClassMapping() != null && cmap.getSuperClassMapping().isInterface()) {
                extendz = extendz + cmap.getSuperClassMapping().getName();
            }
            if (cmap.getMeta(extendz) != null) {
                if (extendz != null) {
                    extendz = extendz + ",";
                }
                extendz = cmap.getMetaAsString("extends");
            }
        } else if (cmap.getSuperClass() != null) {
            if (cmap.getSuperClassMapping() == null || !cmap.getSuperClassMapping().isInterface()) {
                extendz = cmap.getSuperClass();
            }
        } else if (cmap.getMeta("extends") != null) {
            extendz = cmap.getMetaAsString("extends");
        }
        return extendz;
    }

    public boolean hasImplements(ClassMapping cmap) {
        return this.getImplements(cmap) != null;
    }

    public String getImplements(ClassMapping cmap) {
        ArrayList<String> interfaces = new ArrayList<String>();
        if (cmap.getProxy() != null && !cmap.getProxy().equals(cmap.getFullyQualifiedName())) {
            interfaces.add(cmap.getProxy());
        }
        if (!cmap.isInterface()) {
            if (cmap.getSuperClassMapping() != null && cmap.getSuperClassMapping().isInterface()) {
                interfaces.add(cmap.getSuperClassMapping().getClassName().getFullyQualifiedName());
            }
            if (cmap.getMeta("implements") != null) {
                interfaces.addAll(cmap.getMeta("implements"));
            }
            interfaces.add((class$java$io$Serializable == null ? (class$java$io$Serializable = JavaTool.class$("java.io.Serializable")) : class$java$io$Serializable).getName());
        }
        if (interfaces.size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            Iterator iter = interfaces.iterator();
            while (iter.hasNext()) {
                sbuf.append(JavaTool.shortenType(iter.next().toString(), cmap.getImports()));
                if (!iter.hasNext()) continue;
                sbuf.append(",");
            }
            return sbuf.toString();
        }
        return null;
    }

    public String fieldsAsParameters(List fieldslist, ClassMapping classMapping, Map class2classmap) {
        StringBuffer buf = new StringBuffer();
        Iterator fields = fieldslist.iterator();
        while (fields.hasNext()) {
            FieldProperty field = (FieldProperty)fields.next();
            buf.append(JavaTool.shortenType(JavaTool.getTrueTypeName(field, class2classmap), classMapping.getImports()) + " " + field.getFieldName());
            if (!fields.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String fieldsAsArguments(List fieldslist, ClassMapping classMapping, Map class2classmap) {
        StringBuffer buf = new StringBuffer();
        Iterator fields = fieldslist.iterator();
        while (fields.hasNext()) {
            FieldProperty field = (FieldProperty)fields.next();
            buf.append(field.getFieldName());
            if (!fields.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String genImports(ClassMapping classMapping) {
        StringBuffer buf = new StringBuffer();
        Object imports = classMapping.getImports().iterator();
        while (imports.hasNext()) {
            buf.append("import " + imports.next() + ";\n");
        }
        imports = classMapping.getMeta("extra-import");
        if (imports != null) {
            Iterator it = imports.iterator();
            while (it.hasNext()) {
                String cname = it.next().toString();
                buf.append("import " + cname + ";\n");
            }
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

