/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public final class TwoPhaseLoad {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$engine$TwoPhaseLoad == null ? (class$org$hibernate$engine$TwoPhaseLoad = TwoPhaseLoad.class$("org.hibernate.engine.TwoPhaseLoad")) : class$org$hibernate$engine$TwoPhaseLoad));
    static /* synthetic */ Class class$org$hibernate$engine$TwoPhaseLoad;

    private TwoPhaseLoad() {
    }

    public static void postHydrate(EntityPersister persister, Serializable id, Object[] values, Object rowId, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException {
        Object version = Versioning.getVersion(values, persister);
        session.getPersistenceContext().addEntry(object, Status.LOADING, values, rowId, id, version, lockMode, true, persister, false);
        if (log.isTraceEnabled() && version != null) {
            log.trace((Object)("Version: " + version));
        }
    }

    public static void initializeEntity(Object entity, boolean readOnly, SessionImplementor session, PreLoadEvent preLoadEvent, PostLoadEvent postLoadEvent) throws HibernateException {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(entity);
        if (entityEntry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        EntityPersister persister = entityEntry.getPersister();
        Serializable id = entityEntry.getId();
        Object[] hydratedState = entityEntry.getLoadedState();
        if (log.isDebugEnabled()) {
            log.debug((Object)("resolving associations for " + MessageHelper.infoString(persister, id, session.getFactory())));
        }
        Type[] types = persister.getPropertyTypes();
        for (int i = 0; i < hydratedState.length; ++i) {
            Object value = hydratedState[i];
            if (value == LazyPropertyInitializer.UNFETCHED_PROPERTY || value == BackrefPropertyAccessor.UNKNOWN) continue;
            hydratedState[i] = types[i].resolve(value, session, entity);
        }
        preLoadEvent.setEntity(entity).setState(hydratedState).setId(id).setPersister(persister);
        session.getListeners().getPreLoadEventListener().onPreLoad(preLoadEvent);
        persister.setPropertyValues(entity, hydratedState, session.getEntityMode());
        SessionFactoryImplementor factory = session.getFactory();
        if (persister.hasCache() && session.getCacheMode().isPutEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding entity to second-level cache: " + MessageHelper.infoString(persister, id, session.getFactory())));
            }
            CacheEntry entry = new CacheEntry(hydratedState, persister, true, session, entity);
            boolean put = persister.getCache().put(new CacheKey(id, persister.getIdentifierType(), persister.getRootEntityName(), session.getEntityMode(), session.getFactory()), persister.getCacheEntryStructure().structure(entry), session.getTimestamp(), Versioning.getVersion(hydratedState, persister), persister.isVersioned() ? persister.getVersionType().getComparator() : null, factory.getSettings().isMinimalPutsEnabled() && session.getCacheMode() != CacheMode.REFRESH);
            if (put && factory.getStatistics().isStatisticsEnabled()) {
                factory.getStatisticsImplementor().secondLevelCachePut(persister.getCache().getRegionName());
            }
        }
        if (readOnly || !persister.isMutable()) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            TypeFactory.deepCopy(hydratedState, persister.getPropertyTypes(), persister.getPropertyUpdateability(), hydratedState, session);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        persister.afterInitialize(entity, true, session);
        postLoadEvent.setEntity(entity).setId(id).setPersister(persister);
        session.getListeners().getPostLoadEventListener().onPostLoad(postLoadEvent);
        if (log.isDebugEnabled()) {
            log.debug((Object)("done materializing entity " + MessageHelper.infoString(persister, id, session.getFactory())));
        }
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().loadEntity(persister.getEntityName());
        }
    }

    public static void addUninitializedEntity(Serializable id, Object object, EntityPersister persister, LockMode lockMode, SessionImplementor session) {
        session.getPersistenceContext().addEntity(object, Status.LOADING, null, id, null, lockMode, true, persister, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

