/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceInfo;
import javax.persistence.spi.PersistenceProvider;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.ejb.EJB3AutoFlushEventListener;
import org.hibernate.ejb.EJB3FlushEventListener;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.callback.EJB3PostDeleteEventListener;
import org.hibernate.ejb.callback.EJB3PostInsertEventListener;
import org.hibernate.ejb.callback.EJB3PostLoadEventListener;
import org.hibernate.ejb.callback.EJB3PostUpdateEventListener;
import org.hibernate.ejb.callback.EntityCallbackHandler;
import org.hibernate.ejb.xml.PersistenceXml;
import org.hibernate.ejb.xml.PersistenceXmlLoader;
import org.hibernate.mapping.PersistentClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePersistence
implements PersistenceProvider {
    public static final String CLASS_NAMES = "hibernate.ejb.classes";
    public static final String PACKAGE_NAMES = "hibernate.ejb.packages";
    public static final String CFG_FILE = "hibernate.ejb.cfgfile";
    public static final String CLASS_CACHE_PREFIX = "hibernate.ejb.classcache";
    public static final String COLLECTION_CACHE_PREFIX = "hibernate.ejb.collectioncache";
    public static final String HBXML_FILES = "hibernate.hbmxml.files";
    public static final String LOADED_CLASSES = "hibernate.ejb.loaded.classes";

    public EntityManagerFactory createFactory(PersistenceXml xml, Map overrides) {
        if (xml.jarFiles.size() > 0) {
            throw new RuntimeException("<jar-file> not supported yet");
        }
        if (xml.mappingFiles.size() > 0) {
            throw new RuntimeException("<mapping-file not supported yet");
        }
        Properties copy = new Properties();
        if (xml.jtaDatasource != null && !xml.jtaDatasource.equals("")) {
            copy.put("hibernate.connection.datasource", xml.jtaDatasource);
        }
        copy.putAll((Map<?, ?>)xml.props);
        if (!(xml.classes.size() >= 1 || copy.containsKey(LOADED_CLASSES) || copy.containsKey(CLASS_NAMES) || copy.containsKey(HBXML_FILES) || copy.containsKey(CFG_FILE))) {
            throw new MappingException("You must explicitly list all classes in your XML file or use an external hibernate.cfg.xml file (hibernate.ejb.cfgfile).  We will eventually support searching for @Entity classes in your JAR files");
        }
        if (xml.classes.size() > 1 && !copy.containsKey(LOADED_CLASSES) && !copy.containsKey(CLASS_NAMES)) {
            copy.put(CLASS_NAMES, xml.classes);
        }
        if (overrides != null) {
            copy.putAll((Map<?, ?>)overrides);
        }
        return this.createEntityManagerFactory(copy);
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        try {
            Enumeration<URL> xmls = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
            while (xmls.hasMoreElements()) {
                URL url = xmls.nextElement();
                PersistenceXml xml = PersistenceXmlLoader.deploy(url);
                if (xml.provider != null && !xml.provider.equals(this.getClass().getName()) || !(emName == null ? xml.name == null || xml.name.trim().equals("") : emName.equals(xml.name))) continue;
                return this.createFactory(xml, map);
            }
            return null;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceInfo info) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EntityManagerFactory createEntityManagerFactory(Map properties) {
        AnnotationConfiguration cfg = new AnnotationConfiguration();
        cfg.getSessionEventListenerConfig().setFlushEventListener(EJB3FlushEventListener.INSTANCE);
        cfg.getSessionEventListenerConfig().setAutoFlushEventListener(EJB3AutoFlushEventListener.INSTANCE);
        Properties props = new Properties();
        props.setProperty("hibernate.connection.release_mode", "auto");
        props.putAll((Map<?, ?>)properties);
        cfg.setProperties(props);
        if (properties == null || !properties.containsKey(CLASS_NAMES) && !properties.containsKey(LOADED_CLASSES) && !properties.containsKey(HBXML_FILES)) {
            if (properties == null || !properties.containsKey(CFG_FILE)) throw new MappingException("Neither classes declared nor hibernate.cfg.xml file available");
            cfg.configure((String)properties.get(CFG_FILE));
        } else {
            if (properties.containsKey(CLASS_NAMES)) {
                Collection classNames = (Collection)properties.get(CLASS_NAMES);
                this.addNamedAnnotatedClasses(cfg, classNames);
            }
            if (properties.containsKey(LOADED_CLASSES)) {
                List classes = (List)properties.get(LOADED_CLASSES);
                for (Class clazz : classes) {
                    cfg.addAnnotatedClass(clazz);
                }
            }
            if (properties.containsKey(PACKAGE_NAMES)) {
                List packages = (List)properties.get(PACKAGE_NAMES);
                for (String pkg : packages) {
                    cfg.addPackage(pkg);
                }
            }
            if (properties.containsKey(HBXML_FILES)) {
                List hbmXmlFiles = (List)properties.get(HBXML_FILES);
                for (InputStream is : hbmXmlFiles) {
                    cfg.addInputStream(is);
                }
            }
        }
        for (String propertyKey : properties.keySet()) {
            if (propertyKey.startsWith(CLASS_CACHE_PREFIX)) {
                this.setCacheStrategy(propertyKey, properties, cfg, true);
                continue;
            }
            if (!propertyKey.startsWith(COLLECTION_CACHE_PREFIX)) continue;
            this.setCacheStrategy(propertyKey, properties, cfg, false);
        }
        cfg.setProperty("hibernate.connection.autocommit", "true");
        cfg.setProperty("hibernate.use_identifier_rollback", "true");
        EntityCallbackHandler callbackHandler = this.handleCallbacks(cfg);
        return new EntityManagerFactoryImpl(cfg.buildSessionFactory(), callbackHandler);
    }

    private EntityCallbackHandler handleCallbacks(AnnotationConfiguration cfg) {
        EntityCallbackHandler callbackHandler = new EntityCallbackHandler();
        cfg.buildMappings();
        Iterator classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass clazz = (PersistentClass)classes.next();
            callbackHandler.add(clazz.getMappedClass());
        }
        cfg.setListener("post-delete", (Object)new EJB3PostDeleteEventListener(callbackHandler));
        cfg.setListener("post-load", (Object)new EJB3PostLoadEventListener(callbackHandler));
        cfg.setListener("post-update", (Object)new EJB3PostUpdateEventListener(callbackHandler));
        cfg.setListener("post-insert", (Object)new EJB3PostInsertEventListener(callbackHandler));
        return callbackHandler;
    }

    private void setCacheStrategy(String propertyKey, Map properties, AnnotationConfiguration cfg, boolean isClass) {
        String role = propertyKey.substring((isClass ? CLASS_CACHE_PREFIX.length() : COLLECTION_CACHE_PREFIX.length()) + 1);
        String value = (String)properties.get(propertyKey);
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            StringBuffer error = new StringBuffer("Illegal usage of ");
            error.append(isClass ? CLASS_CACHE_PREFIX : COLLECTION_CACHE_PREFIX);
            error.append(": ").append(propertyKey).append(" ").append(value);
            throw new MappingException(error.toString());
        }
        String usage = params.nextToken();
        String region = null;
        if (params.hasMoreTokens()) {
            region = params.nextToken();
        }
        if (isClass) {
            cfg.setCacheConcurrencyStrategy(role, usage, region);
        } else {
            cfg.setCollectionCacheConcurrencyStrategy(role, usage, region);
        }
    }

    private void addNamedAnnotatedClasses(AnnotationConfiguration cfg, Collection<String> classNames) {
        for (String name : classNames) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(name);
                cfg.addAnnotatedClass(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                Package pkg = Package.getPackage(name);
                if (pkg == null) {
                    throw new IllegalArgumentException("class not found", cnfe);
                }
                cfg.addPackage(name);
            }
        }
    }
}

