/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.Serializable;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.TransactionRequiredException;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.hibernate.ejb.QueryImpl;
import org.hibernate.ejb.TransactionImpl;
import org.hibernate.engine.SessionImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityManagerImpl
implements HibernateEntityManager,
Serializable {
    protected TransactionImpl tx = new TransactionImpl(this);
    protected PersistenceContextType type;

    protected AbstractEntityManagerImpl(PersistenceContextType type) {
        this.type = type;
    }

    public javax.persistence.Query createQuery(String ejbqlString) {
        return new QueryImpl(this.getSession().createQuery(ejbqlString));
    }

    public javax.persistence.Query createNamedQuery(String name) {
        return new QueryImpl(this.getSession().getNamedQuery(name));
    }

    public javax.persistence.Query createNativeQuery(String sqlString) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        SQLQuery q = this.getSession().createSQLQuery(sqlString);
        q.addEntity("alias1", resultClass.getName(), LockMode.READ);
        return new QueryImpl((Query)q);
    }

    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        SQLQuery q = this.getSession().createSQLQuery(sqlString);
        q.setResultSetMapping(resultSetMapping);
        return new QueryImpl((Query)q);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try {
            Object rtn = this.getSession().load(entityClass, (Serializable)primaryKey);
            return (T)rtn;
        }
        catch (ObjectNotFoundException e) {
            throw new EntityNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public <A> A find(Class<A> entityClass, Object primaryKey) {
        try {
            Object rtn = this.getSession().get(entityClass, (Serializable)primaryKey);
            return (A)rtn;
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String getEntityName(Object entity) {
        return this.getEntityName(entity.getClass());
    }

    public String getEntityName(Class clazz) {
        return clazz.getName();
    }

    private void checkTransactionActive() {
        if (!((SessionImplementor)this.getSession()).isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress");
        }
    }

    public void persist(Object entity) {
        this.checkTransactionActive();
        try {
            this.getSession().persist(this.getEntityName(entity), entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public <A> A merge(A entity) {
        this.checkTransactionActive();
        try {
            return (A)this.getSession().merge(this.getEntityName(entity), entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void remove(Object entity) {
        this.checkTransactionActive();
        try {
            this.getSession().delete(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void refresh(Object entity) {
        this.checkTransactionActive();
        try {
            this.getSession().refresh(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public boolean contains(Object entity) {
        try {
            if (entity != null && this.getSession().getSessionFactory().getClassMetadata(entity.getClass()) == null) {
                throw new IllegalArgumentException("Not an entity:" + entity.getClass());
            }
            return this.getSession().contains(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public void flush() {
        this.getSession().flush();
    }

    @Override
    public abstract Session getSession();

    public EntityTransaction getTransaction() {
        return this.tx;
    }

    public void setFlushMode(FlushModeType flushMode) {
        if (flushMode == FlushModeType.AUTO) {
            this.getSession().setFlushMode(FlushMode.AUTO);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.getSession().setFlushMode(FlushMode.COMMIT);
        } else if (flushMode == FlushModeType.NEVER) {
            if (this.type == PersistenceContextType.TRANSACTION) {
                throw new IllegalStateException("You cannot set FlushModeType to NEVER for a TRANSACTION persistence context");
            }
            this.getSession().setFlushMode(FlushMode.NEVER);
        }
    }
}

