/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.avalon;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.avalon.HibernateService;
import net.sf.hibernate.cfg.Configuration;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;

public class HibernateServiceImpl
extends AbstractLogEnabled
implements HibernateService,
Initializable,
Parameterizable,
Disposable {
    private static final String PARAMETER_NAME_PROPERTIES_URL = "hibernate.properties.url";
    private static final String PARAMETER_NAME_PROPERTIES_FILENAME = "hibernate.properties.filename";
    private static final String PARAMETER_NAME_CONFIGURATION_URL = "hibernate.configuration.url";
    private static final String PARAMETER_NAME_CONFIGURATION_FILENAME = "hibernate.configuration.filename";
    private static final String PARAMETER_NAME_CONFIGURATION_RESOURCE = "hibernate.configuration.resource";
    private Configuration m_configuration = new Configuration();
    private SessionFactory m_sessionFactory = null;

    public Session openSession() throws HibernateException {
        return this.m_sessionFactory.openSession();
    }

    public void initialize() throws Exception {
        this.m_sessionFactory = this.m_configuration.buildSessionFactory();
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.loadProperties(parameters);
        this.loadConfiguration(parameters);
    }

    private void loadProperties(Parameters parameters) {
        Properties properties = Parameters.toProperties((Parameters)parameters);
        if (!this.loadPropertiesFromUrl(parameters, properties)) {
            // empty if block
        }
        this.loadPropertiesFromFile(parameters, properties);
        this.m_configuration.addProperties(properties);
    }

    private void loadConfiguration(Parameters parameters) {
        if (!(this.loadConfigurationFromUrl(parameters) || this.loadConfigurationFromFile(parameters) || this.loadConfigurationFromResource(parameters))) {
            this.loadConfigurationDefault();
        }
    }

    private boolean loadPropertiesFromUrl(Parameters parameters, Properties properties) {
        String paramsUrl = parameters.getParameter(PARAMETER_NAME_PROPERTIES_URL, null);
        boolean success = false;
        if (paramsUrl != null) {
            try {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("loading parameters from URL: " + paramsUrl);
                }
                URL url = new URL(paramsUrl);
                properties.load(url.openStream());
                success = true;
            }
            catch (Exception e) {
                this.getLogger().error("Could not load parameters from URL: " + paramsUrl, (Throwable)e);
            }
        }
        return success;
    }

    private boolean loadPropertiesFromFile(Parameters parameters, Properties properties) {
        String paramsFile = parameters.getParameter(PARAMETER_NAME_PROPERTIES_FILENAME, null);
        boolean success = false;
        if (paramsFile != null) {
            try {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("loading parameters from file: " + paramsFile);
                }
                properties.load(new FileInputStream(paramsFile));
                success = true;
            }
            catch (Exception e) {
                this.getLogger().error("Could not load parameters from file: " + paramsFile, (Throwable)e);
            }
        }
        return success;
    }

    private boolean loadConfigurationFromUrl(Parameters parameters) {
        String confUrl = parameters.getParameter(PARAMETER_NAME_CONFIGURATION_URL, null);
        boolean success = false;
        if (confUrl != null) {
            try {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("configuring from URL: " + confUrl);
                }
                URL url = new URL(confUrl);
                this.m_configuration.configure(url);
                success = true;
            }
            catch (Exception e) {
                this.getLogger().error("Error while configuring from URL: " + confUrl, (Throwable)e);
            }
        }
        return success;
    }

    private boolean loadConfigurationFromFile(Parameters parameters) {
        String confFile = parameters.getParameter(PARAMETER_NAME_CONFIGURATION_FILENAME, null);
        boolean success = false;
        if (confFile != null) {
            try {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("configuring from file: " + confFile);
                }
                File file = new File(confFile);
                this.m_configuration.configure(file);
                success = true;
            }
            catch (Exception e) {
                this.getLogger().error("Error while configuring from file: " + confFile, (Throwable)e);
            }
        }
        return success;
    }

    private boolean loadConfigurationFromResource(Parameters parameters) {
        String confResource = parameters.getParameter(PARAMETER_NAME_CONFIGURATION_RESOURCE, null);
        boolean success = false;
        if (confResource != null) {
            try {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("configuring from resource: " + confResource);
                }
                this.m_configuration.configure(confResource);
                success = true;
            }
            catch (HibernateException e) {
                this.getLogger().error("Error while configuring from resource: " + confResource, (Throwable)e);
            }
        }
        return success;
    }

    private void loadConfigurationDefault() {
        try {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("configuration not specified, applying default");
            }
            this.m_configuration.configure();
        }
        catch (HibernateException e) {
            this.getLogger().error("Error while configuring", (Throwable)e);
        }
    }

    public void dispose() {
        if (this.m_sessionFactory != null) {
            try {
                this.m_sessionFactory.close();
            }
            catch (HibernateException e) {
                this.getLogger().warn("Error while closing factory", (Throwable)e);
            }
            this.m_sessionFactory = null;
        }
    }
}

