//$Id: Past.java,v 1.3 2005/08/12 20:06:22 oneovthafew Exp $
package org.hibernate.validator;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import java.lang.annotation.Target;

/**
 * Check that a Date, a Calendar, or a string representation apply in the past
 *
 * @author Gavin King
 */
@Documented
@ValidatorClass(PastValidator.class)
@Target({METHOD, FIELD})
@Retention(RUNTIME)
public @interface Past {
	String message() default "must be a past date";
}
