//$Id: Min.java,v 1.3 2005/08/12 20:06:22 oneovthafew Exp $
package org.hibernate.validator;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import java.lang.annotation.Target;

/**
 * min restriction on a numeric annotated elemnt (or the string representation of a numeric)
 *
 * @author Gavin King
 */
@Documented
@ValidatorClass(MinValidator.class)
@Target({METHOD, FIELD})
@Retention(RUNTIME)
public @interface Min {
	int value();

	String message() default "must greater than or equal to {value}";
}
