//$Id: InvalidValue.java,v 1.3 2005/09/23 05:47:28 oneovthafew Exp $
package org.hibernate.validator;

import java.io.Serializable;

/**
 * A single violation of a class level or method level constraint.
 *
 * @author Gavin King
 */
public class InvalidValue implements Serializable {
	private final String message;
	private final Object value;
	private final String propertyName;
	private final Class beanClass;
	private final Object bean;

	public InvalidValue(String message, Class beanClass, String propertyName, Object value, Object bean) {
		this.message = message;
		this.value = value;
		this.beanClass = beanClass;
		this.propertyName = propertyName;
		this.bean = bean;
	}

	public Class getBeanClass() {
		return beanClass;
	}

	public String getMessage() {
		return message;
	}

	public String getPropertyName() {
		return propertyName;
	}

	public Object getValue() {
		return value;
	}

	public Object getBean() {
		return bean;
	}

	public String toString() {
		return propertyName + ' ' + message;
	}

}
