//$Id: PropertyHolderBuilder.java,v 1.8 2005/09/06 22:13:36 epbernard Exp $
package org.hibernate.cfg;

import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;

import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Join;
import org.hibernate.util.StringHelper;

/**
 * This factory is here ot build a PropertyHolder and prevent .mapping interface adding
 *
 * @author Emmanuel Bernard
 */
public final class PropertyHolderBuilder {
	private PropertyHolderBuilder() {
	}

	public static PropertyHolder buildPropertyHolder(
			PersistentClass persistentClass, Map<String, Column[]> columnOverride, Map<String, Join> joins
	) {
		return (PropertyHolder) new ClassPropertyHolder( persistentClass, columnOverride, joins );
	}

	/**
	 * build a component property holder
	 *
	 * @param component component to wrap
	 * @param path	  component path
	 * @return PropertyHolder
	 */
	public static PropertyHolder buildPropertyHolder(
			Component component, String path, Map<String, Column[]> columnOverride
	) {
		return (PropertyHolder) new ComponentPropertyHolder( component, path, columnOverride );
	}

	/**
	 * buid a property holder on top of a collection
	 */
	public static PropertyHolder buildPropertyHolder(Collection collection, String path) {
		return new CollectionPropertyHolder( collection, path );
	}

	public static PropertyHolder buildPropertyHolder(PersistentClass persistentClass, Map<String, Join> joins) {
		return buildPropertyHolder( persistentClass, new HashMap<String, Column[]>(), joins );
	}

	public static Map<String, Column[]> buildColumnOverride(AnnotatedElement element, String path) {
		AttributeOverride singleOverride = element.getAnnotation( AttributeOverride.class );
		AttributeOverrides multipleOverrides = element.getAnnotation( AttributeOverrides.class );
		AttributeOverride[] overrides;
		if ( singleOverride != null ) {
			overrides = new AttributeOverride[]{singleOverride};
		}
		else if ( multipleOverrides != null ) {
			overrides = multipleOverrides.value();
		}
		else {
			overrides = null;
		}
		Map<String, Column[]> columnOverride = new HashMap<String, Column[]>();
		//fill overriden columns
		if ( overrides != null ) {
			for ( AttributeOverride depAttr : overrides ) {
				columnOverride.put(
						StringHelper.qualify( path, depAttr.name() ),
						new Column[]{depAttr.column()}
				);
			}
		}
		return columnOverride;
	}
}
