// $Id: FkSecondPass.java,v 1.9 2005/09/05 10:34:55 epbernard Exp $
package org.hibernate.cfg;

import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Value;

/**
 * Enable a proper set of the FK columns in respect with the id column order
 * Allow the correct implementation of the default EJB3 values which needs both
 * sides of the association to be resolved
 *
 * @author Emmanuel Bernard
 */
public class FkSecondPass implements SecondPass {
	private Value value;
	private Ejb3JoinColumn[] columns;
	private boolean unique;
	private Mappings mappings;

	FkSecondPass(Value value, Ejb3JoinColumn[] columns, boolean unique, Mappings mappings) {
		this.mappings = mappings;
		this.value = value;
		this.columns = columns;
		this.unique = unique;
	}

	public void doSecondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
		if ( value instanceof ManyToOne ) {
			ManyToOne manyToOne = (ManyToOne) value;
			AnnotationBinder.bindFkSecondPass(
					(ManyToOne) value,
					columns,
					persistentClasses,
					unique,
					(ExtendedMappings) mappings
			);
			/*
			 * HbmBinder does this only when property-ref != null, but IMO, it makes sense event if it is null
			 */
			if ( ! manyToOne.isIgnoreNotFound() ) manyToOne.createPropertyRefConstraints( persistentClasses );
		}
		else {
			throw new AssertionFailure( "FkSecondPass for a wrong value type: " + value.getClass().getName() );
		}
	}
}
