//$Id: CollectionPropertyHolder.java,v 1.5 2005/09/06 22:13:36 epbernard Exp $
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;

import org.hibernate.AssertionFailure;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

/**
 * @author Emmanuel Bernard
 */
public class CollectionPropertyHolder implements PropertyHolder {
	Collection collection;
	private String path;

	public CollectionPropertyHolder(Collection collection, String path) {
		this.collection = collection;
		this.path = path;
	}

	public String getClassName() {
		throw new AssertionFailure( "Collection property holder does not have a class name" );
	}

	public Table getTable() {
		return collection.getCollectionTable();
	}

	public void addProperty(Property prop) {
		throw new AssertionFailure( "Cannot add property to a collection" );
	}

	public KeyValue getIdentifier() {
		throw new AssertionFailure( "Identifier collection not yet managed" );
	}

	public PersistentClass getPersistentClass() {
		return collection.getOwner();
	}

	public boolean isComponent() {
		return false;
	}

	public String getPath() {
		return path;
	}

	public Column[] getOverriddenColumn(String propertyName) {
		return null;
	}

	public Map<String, Column[]> mergeOverridenColumns(Map<String, Column[]> localColumnOverride) {
		Map<String, Column[]> columns = new HashMap<String, Column[]>(localColumnOverride);
		return columns;
	}

	public String getEntityName() {
		return collection.getOwner().getEntityName();
	}

	public void addProperty(Property prop, Ejb3Column[] columns) {
		//Ejb3Column.checkPropertyConsistency( ); //already called earlier
		throw new AssertionFailure("addProperty to a join table of a collection: does it make sense?");
	}
}
