//$Id: ClassPropertyHolder.java,v 1.10 2005/09/06 22:13:36 epbernard Exp $
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;

import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.Component;

/**
 * @author Emmanuel Bernard
 */
public class ClassPropertyHolder implements PropertyHolder {
	private PersistentClass persistentClass;
	private Map<String, Column[]> columnOverride;
	private Map<String, Join> joins;

	public ClassPropertyHolder(
			PersistentClass persistentClass, Map<String, Column[]> columnOverride, Map<String, Join> joins
	) {
		this.persistentClass = persistentClass;
		this.columnOverride = columnOverride;
		this.joins = joins;
	}

	public String getPath() {
		return persistentClass.getEntityName();
	}

	public Column[] getOverriddenColumn(String propertyName) {
		return columnOverride.get( propertyName );
	}

	public Map<String, Column[]> mergeOverridenColumns(Map<String, Column[]> localColumnOverride) {
		Map<String, Column[]> merge = new HashMap<String, Column[]>( localColumnOverride );
		merge.putAll( columnOverride );
		return merge;
	}

	public String getEntityName() {
		return persistentClass.getEntityName();
	}

	public void addProperty(Property prop, Ejb3Column[] columns) {
		//Ejb3Column.checkPropertyConsistency( ); //already called earlier
		if ( columns[0].isSecondary() ) {
			//TODO move the getJoin() code here?
			columns[0].getJoin().addProperty( prop );
		}
		else {
			addProperty( prop );
		}
	}

	public void addProperty(Property prop) {
		if ( prop.getValue() instanceof Component ) {
			//TODO handle quote and non quote table comparison
			String tableName = prop.getValue().getTable().getName();
			if ( joins.containsKey( tableName ) ) {
				joins.get(tableName).addProperty( prop );
			}
			else {
				persistentClass.addProperty( prop );
			}
		}
		else {
			persistentClass.addProperty( prop );
		}
	}

	public String getClassName() {
		return persistentClass.getClassName();
	}

	public Table getTable() {
		return persistentClass.getTable();
	}

	public boolean isComponent() {
		return false;
	}

	public PersistentClass getPersistentClass() {
		return persistentClass;
	}

	public KeyValue getIdentifier() {
		return persistentClass.getIdentifier();
	}
}
