//$Id: ValidatePreUpdateEventListener.java,v 1.1 2005/05/27 08:58:53 epbernard Exp $
package org.hibernate.validator.event;

import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.def.DefaultPreUpdateEventListener;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;

/**
 * Before update, execute the validator framework
 * @author Gavin King
 */
public class ValidatePreUpdateEventListener extends DefaultPreUpdateEventListener {

	public boolean onPreUpdate(PreUpdateEvent event) {
		//TODO: cache the validator
		InvalidValue[] invalidValues = new ClassValidator( event.getEntity().getClass() )
				.getInvalidValues( event.getEntity() );
		if (invalidValues.length>0) {
			throw new InvalidStateException(invalidValues);
		}
		return super.onPreUpdate( event );
	}

}
