//$Id: Range.java,v 1.1 2005/05/27 08:58:54 epbernard Exp $
package org.hibernate.validator;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The annotated elemnt has to be in the appropriate range. Apply on numeric values or string
 * representation of the numeric value.
 * @author Gavin King
 */
@ValidatorClass(RangeValidator.class)
@Target(METHOD) @Retention(RUNTIME)
public @interface Range {
	long max() default Long.MAX_VALUE;
	long min() default Long.MIN_VALUE;
	String message() default "must be between {min} and {max}";
}
