//$Id: Length.java,v 1.1 2005/05/27 08:58:53 epbernard Exp $
package org.hibernate.validator;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Apply some length restrictions to the annotated element. It has to be a string
 * @author Gavin King
 */
@ValidatorClass(LengthValidator.class)
@Target(METHOD) @Retention(RUNTIME)
public @interface Length {
	int max() default Integer.MAX_VALUE;
	int min() default 0;
	String message() default "length must be between {min} and {max}";
}
