//$Id: InvalidStateException.java,v 1.1 2005/05/27 08:58:53 epbernard Exp $
package org.hibernate.validator;

/**
 * Thrown when the bean has violated one or several of its constraints
 * You can get the violation details in getInvalidValues()
 * 
 * @author Gavin King
 */
public class InvalidStateException extends RuntimeException {
	
	private final InvalidValue[] invalidValues;
	
	public InvalidStateException(InvalidValue[] invalidValues) {
		super( "validation failed for: " + invalidValues[0].getBeanClass().getName() );
		this.invalidValues = invalidValues;
	}
	
	public InvalidValue[] getInvalidValues() {
		return invalidValues;
	}

}
