//$Id: SimpleValueBinder.java,v 1.2 2005/05/16 17:43:07 epbernard Exp $
package org.hibernate.cfg.annotations;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Mappings;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;

/**
 * @author Emmanuel Bernard
 */
public class SimpleValueBinder {
	private static Log log = LogFactory.getLog(SimpleValueBinder.class);
	private String propertyName;
	private String returnedClassName;
	private Ejb3Column[] columns;
	private String persistentClassName;
	private String explicitType = "";
	private Properties typeParameters = new Properties();
	private Mappings mappings;

	public void setPropertyName(String propertyName) {
		this.propertyName = propertyName;
	}

	public void setReturnedClassName(String returnedClassName) {
		this.returnedClassName = returnedClassName;
	}

	public void setColumns(Ejb3Column[] columns) {
		this.columns = columns;
	}


	public void setPersistentClassName(String persistentClassName) {
		this.persistentClassName = persistentClassName;
	}

	public void setExplicitType(String explicitType) {
		this.explicitType = explicitType;
	}
    //FIXME raise an assertion failure  if setExplicitType(String) and setExplicitType(Type) are use at the same time
	public void setExplicitType(Type typeAnn) {
		if (typeAnn!= null) {
			explicitType = typeAnn.type();
			for ( Parameter param : typeAnn.parameters() ) {
				typeParameters.setProperty( param.name(), param.value() );
			}
		}
	}

	public void setTypeParameters(Properties typeParameters) {
		this.typeParameters = typeParameters;
	}

	public void setMappings(Mappings mappings) {
		this.mappings = mappings;
	}

	private void validate() {
		//TODO check necessary params
		Ejb3Column.checkPropertyConsistency(columns, propertyName);
	}

	public SimpleValue make() {
		validate();
		log.debug("building SimpleValue for " + propertyName);
		Table table = columns[0].getTable();
		SimpleValue simpleValue = new SimpleValue(table);
		return fillSimpleValue(simpleValue);
	}

	private SimpleValue fillSimpleValue(SimpleValue simpleValue) {
		String type = AnnotationBinder.isDefault( explicitType ) ? returnedClassName : explicitType;
		org.hibernate.mapping.TypeDef typeDef = mappings.getTypeDef(type);
		if (typeDef != null) {
			type = typeDef.getTypeClass();
			simpleValue.setTypeParameters( typeDef.getParameters() );
		}
		if ( typeParameters != null && typeParameters.size() != 0) {
			//explicit type params takes precedence over type def params
			simpleValue.setTypeParameters( typeParameters );
		}
		simpleValue.setTypeName(type);
		if (persistentClassName != null) {
			simpleValue.setTypeUsingReflection( persistentClassName, propertyName );
		}
		for (Ejb3Column column : columns) {
			column.linkWithValue(simpleValue);
		}
		return simpleValue;
	}
}
