//$Id: MapBinder.java,v 1.2 2005/07/22 22:36:07 epbernard Exp $
package org.hibernate.cfg.annotations;

import java.util.Map;

import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.AssertionFailure;
import org.hibernate.AnnotationException;

/**
 * Implementation to bind a Map
 *
 * @author Emmanuel Bernard
 */
public class MapBinder extends CollectionBinder {

	protected Collection createCollection(PersistentClass persistentClass) {
		return new org.hibernate.mapping.Map(persistentClass);
	}

	public SecondPass getSecondPass(final ExtendedMappings mappings,
											  final Ejb3JoinColumn[] keyColumns,
											  final Ejb3JoinColumn[] inverseColumns,
											  final String collType,
											  final FetchMode fetchMode,
											  final boolean unique) {
		if (inverseColumns != null) {
			return new SecondPass(mappings, MapBinder.this.collection) {
				public void secondPass(Map persistentClasses, Map inheritedMetas)
						throws MappingException {
					bindManyToManySecondPass(MapBinder.this.collection,
							persistentClasses,
							keyColumns,
							inverseColumns,
							collType,
							fetchMode,
							unique,
							cascadeDeleteEnabled, (ExtendedMappings) mappings);
					bindKeyFromAssociationTable(collType, persistentClasses, mapKeyPropertyName, mappings);
				}
			};
		}
		else {
			return new SecondPass(mappings, collection) {
				public void secondPass(Map persistentClasses, Map inheritedMetas)
						throws MappingException {
					bindCollectionSecondPass(MapBinder.this.collection,
							persistentClasses,
							keyColumns,
							cascadeDeleteEnabled, hqlOrderBy, (ExtendedMappings) mappings);
					if ( MapBinder.this.collection.isOneToMany() ) {
						org.hibernate.mapping.OneToMany oneToMany =	(org.hibernate.mapping.OneToMany)
								MapBinder.this.collection.getElement();
						String collType = oneToMany.getReferencedEntityName();
						bindKeyFromAssociationTable(collType, persistentClasses, mapKeyPropertyName, mappings);
					}
					else {
						throw new AssertionFailure("Should be a one to many");
					}
				}
			};
		}
	}

	private void bindKeyFromAssociationTable(
			String collType, Map persistentClasses, String mapKeyPropertyName, ExtendedMappings mappings
			) {
		if (mapKeyPropertyName == null) throw new AnnotationException("A Map must declare a @MapKey element");
		PersistentClass associatedClass = (PersistentClass) persistentClasses.get(collType);
		if (associatedClass == null) throw new AnnotationException("Associated class not found: " + collType);
		Property property = BinderHelper.findPropertyByName( associatedClass, mapKeyPropertyName);
		if (property == null) throw new AnnotationException("Map key property not found: " + collType + "." + mapKeyPropertyName);
		org.hibernate.mapping.Map map = (org.hibernate.mapping.Map) this.collection;
		map.setIndex( property.getValue() );
	}
}
