//$Id: PropertyHolderBuilder.java,v 1.6 2005/06/20 17:11:01 epbernard Exp $
package org.hibernate.cfg;

import java.util.Map;
import java.util.HashMap;
import java.lang.reflect.AnnotatedElement;
import javax.persistence.Column;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;

import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;

/**
 * This factory is here ot build a PropertyHolder and prevent .mapping interface adding
 *
 * @author Emmanuel Bernard
 */
public final class PropertyHolderBuilder {
	private PropertyHolderBuilder() {}

	public static PropertyHolder buildPropertyHolder(PersistentClass persistentClass, Map<String, Column[]> columnOverride) {
		return (PropertyHolder) new ClassPropertyHolder(persistentClass, columnOverride);
	}

	/**
	 * build a component property holder
	 *
	 * @param component component to wrap
	 * @param path component path
	 * @return PropertyHolder
	 */
	public static PropertyHolder buildPropertyHolder(Component component, String path, Map<String, Column[]> columnOverride) {
		return (PropertyHolder) new ComponentPropertyHolder(component, path, columnOverride);
	}

	/** buid a property holder on top of a collection */
	public static PropertyHolder buildPropertyHolder(Collection collection, String path) {
		return new CollectionPropertyHolder( collection, path );
	}

	public static PropertyHolder buildPropertyHolder(PersistentClass persistentClass) {
		return buildPropertyHolder( persistentClass, new HashMap<String, Column[]>() );
	}

	public static Map<String, Column[]> buildColumnOverride(AnnotatedElement element) {
		AttributeOverride singleOverride = element.getAnnotation(AttributeOverride.class);
		AttributeOverrides multipleOverrides = element.getAnnotation(AttributeOverrides.class);
		AttributeOverride[] overrides;
		if (singleOverride != null) {
			overrides = new AttributeOverride[] { singleOverride };
		}
		else if (multipleOverrides != null) {
			overrides = multipleOverrides.value();
		}
		else {
			overrides = null;
		}
		Map<String, Column[]> columnOverride = new HashMap<String, Column[]>();
		//fill overriden columns
		if (overrides != null) {
			for ( AttributeOverride depAttr : overrides ) {
				columnOverride.put( depAttr.name(), new Column[] { depAttr.column() } );
			}
		}
		return columnOverride;
	}
}
