package org.hibernate.cfg;

import java.util.Map;
import javax.persistence.Column;

import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

/**
 * Property holder abstract property containers from their direct implementation
 *
 * @author Emmanuel Bernard
 */
public interface PropertyHolder {
	String getClassName();
	Table getTable();
	void addProperty(Property prop);
	KeyValue getIdentifier();
	PersistentClass getPersistentClass();
	boolean isComponent();
	String getPath();
	/**
	 * return null if the column is not overridden, or an array of column if true
	 */
	Column[] getOverriddenColumn(String propertyName);
	Map<String, Column[]> mergeOverridenColumns(Map<String, Column[]> localColumnOverride);

	String getEntityName();
}
