//$Id: InheritanceState.java,v 1.4 2005/06/17 09:15:14 epbernard Exp $
package org.hibernate.cfg;

import java.lang.reflect.AnnotatedElement;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.AccessType;

/**
 * Some extra data to the inheritance position of a class
 *
 * @author Emmanuel Bernard
 */
public class InheritanceState {
	public boolean hasSons = false;
	public boolean hasParents = false;
	public boolean hasEmbeddedSuperclass = false;
	public InheritanceType type;
	public boolean isEmbeddableSuperclass = false;
	/** only defined on embedded superclasses */
	public AccessType accessType = null;

	public void setInheritanceType(AnnotatedElement clazz) {
		Inheritance inhAnn = clazz.getAnnotation(Inheritance.class);
		EmbeddableSuperclass superclassAnn = clazz.getAnnotation( EmbeddableSuperclass.class );
		if ( superclassAnn != null ) {
			isEmbeddableSuperclass = true;
			type = inhAnn == null ? null : inhAnn.strategy();
			accessType = superclassAnn.access();
		}
		else {
			type = inhAnn == null ? InheritanceType.SINGLE_TABLE : inhAnn.strategy();
		}
	}

	boolean hasTable() {
		return !hasParents || !InheritanceType.SINGLE_TABLE.equals(type);
	}

	boolean hasDenormalizedTable() {
		return hasParents && InheritanceType.TABLE_PER_CLASS.equals(type);
	}
}
