// $Id: FkSecondPass.java,v 1.5 2005/07/20 00:06:10 epbernard Exp $
package org.hibernate.cfg;

import java.util.Map;

import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Value;

/**
 * Enable a proper set of the FK columns in respect with the id column order
 * Allow the correct implementation of the default EJB3 values which needs both
 * sides of the association to be resolved
 *
 * @author Emmanuel Bernard
 */
public class FkSecondPass extends SecondPass {
	private Value value;
	private Ejb3JoinColumn[] columns;
	private boolean unique;

	FkSecondPass(Value value, Ejb3JoinColumn[] columns, boolean unique, Mappings mappings) {
		super(mappings, null);
		this.value = value;
		this.columns = columns;
		this.unique = unique;
	}

	void doSecondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
		secondPass(persistentClasses, inheritedMetas);
	}

	public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
		if (value instanceof ManyToOne) {
			ManyToOne manyToOne = (ManyToOne) value;
			AnnotationBinder.bindFkSecondPass(
					(ManyToOne) value,
					columns,
					persistentClasses,
					unique,
					(ExtendedMappings) mappings
			);
			manyToOne.createPropertyRefConstraints(persistentClasses);
		}
		else {
			throw new AssertionFailure("FkSecondPass for a wrong value type: " + value.getClass().getName() );
		}
	}
}
