//$Id: ComponentPropertyHolder.java,v 1.5 2005/06/20 17:11:00 epbernard Exp $
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;

import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

/**
 * Component implementation of property holder
 * @author Emmanuel Bernard
 */
public class ComponentPropertyHolder implements PropertyHolder {
	private Component component;
	String path;
	private Map<String, Column[]> columnOverride;

	public String getPath() {
		return path;
	}

	public Column[] getOverriddenColumn(String propertyName) {
		return columnOverride.get(propertyName);
	}

	public String getEntityName() {
		return component.getComponentClassName();
	}

	public ComponentPropertyHolder(Component component, String path, Map<String, Column[]> columnOverride) {
		this.component = component;
		this.path = path;
		this.columnOverride = columnOverride;
	}
	public String getClassName() {
		return component.getComponentClassName();
	}

	public Table getTable() {
		return component.getTable();
	}

	public void addProperty(Property prop) {
		component.addProperty(prop);
	}

	public KeyValue getIdentifier() {
		return component.getOwner().getIdentifier();
	}

	public PersistentClass getPersistentClass() {
		return component.getOwner();
	}

	public boolean isComponent() {
		return true;
	}

	public Map<String, Column[]> mergeOverridenColumns(Map<String, Column[]> localColumnOverride) {
		Map<String, Column[]> merge = new HashMap<String, Column[]>(localColumnOverride);
		merge.putAll(localColumnOverride);
		return merge;
	}
}
