/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class EnumType
implements UserType,
ParameterizedType {
    private static Log log = LogFactory.getLog(EnumType.class);
    private static Map<Class, Object[]> enumValues = new HashMap<Class, Object[]>();
    public static final String ENUM = "enumClass";
    private Class<? extends Enum> enumClass;

    public int[] sqlTypes() {
        return new int[]{4};
    }

    public Class returnedClass() {
        return this.enumClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Object object = rs.getObject(names[0]);
        if (rs.wasNull()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning null as column " + names[0]));
            }
            return null;
        }
        if (object instanceof Number) {
            int ordinal;
            Object[] values = enumValues.get(this.enumClass);
            if (values == null) {
                try {
                    Method method = null;
                    method = this.enumClass.getDeclaredMethod("values", new Class[0]);
                    values = (Object[])method.invoke(null, new Object[0]);
                    enumValues.put(this.enumClass, values);
                }
                catch (Exception e) {
                    throw new MappingException("Error while accessing enum.values(): " + this.enumClass, (Throwable)e);
                }
            }
            if ((ordinal = ((Number)object).intValue()) < 0 || ordinal >= values.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + ordinal);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning '" + ordinal + "' as column " + names[0]));
            }
            return values[ordinal];
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning '" + Enum.valueOf(this.enumClass, (String)object) + "' as column " + names[0]));
        }
        String name = (String)object;
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + name, iae);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        int paramType = st.getParameterMetaData().getParameterType(index);
        if (paramType == 12) {
            if (value == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Binding null to parameter: " + index));
                }
                st.setNull(index, 12);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Binding '" + ((Enum)value).name() + "' to parameter: " + index));
                }
                st.setString(index, ((Enum)value).name());
            }
        } else if (paramType == 4) {
            if (value == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Binding null to parameter: " + index));
                }
                st.setNull(index, 4);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Binding '" + ((Enum)value).ordinal() + "' to parameter: " + index));
                }
                st.setInt(index, ((Enum)value).ordinal());
            }
        } else {
            throw new IllegalArgumentException("SQL Type not supported for Enums: " + paramType);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty(ENUM);
        try {
            this.enumClass = Class.forName(enumClassName).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException exception) {
            throw new HibernateException("Enum class not found", (Throwable)exception);
        }
    }
}

