/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.util.StringHelper;

public abstract class TableBinder {
    private static Log log = LogFactory.getLog(TableBinder.class);

    public static Table fillTable(String schema, String catalog, String realTableName, boolean isAbstract, List uniqueConstraints, String constraints, Table denormalizedSuperTable, ExtendedMappings mappings) {
        schema = AnnotationBinder.isDefault(schema) ? (schema = mappings.getSchemaName()) : schema;
        catalog = AnnotationBinder.isDefault(catalog) ? (catalog = mappings.getCatalogName()) : catalog;
        Table table = denormalizedSuperTable != null ? mappings.addDenormalizedTable(schema, catalog, realTableName, isAbstract, null, denormalizedSuperTable) : mappings.addTable(schema, catalog, realTableName, null, isAbstract);
        if (uniqueConstraints != null && uniqueConstraints.size() > 0) {
            mappings.addUniqueConstraints(table, uniqueConstraints);
        }
        if (constraints != null) {
            table.addCheckConstraint(constraints);
        }
        return table;
    }

    public static void bindManytoManyInverseFk(PersistentClass referencedEntity, Ejb3JoinColumn[] columns, SimpleValue value, boolean unique) {
        if (!StringHelper.isEmpty((String)columns[0].getMappedBy())) {
            Property property = referencedEntity.getProperty(columns[0].getMappedBy());
            Iterator mappedByColumns = ((Collection)property.getValue()).getKey().getColumnIterator();
            while (mappedByColumns.hasNext()) {
                Column column = (Column)mappedByColumns.next();
                columns[0].linkValueUsingAColumnCopy(column, value);
            }
            value.createForeignKey();
        } else {
            TableBinder.bindFk(referencedEntity, null, columns, value, unique);
        }
    }

    public static void bindFk(PersistentClass referencedEntity, PersistentClass destinationEntity, Ejb3JoinColumn[] columns, SimpleValue value, boolean unique) {
        if (!StringHelper.isEmpty((String)columns[0].getMappedBy())) {
            Property property;
            PersistentClass associatedClass = destinationEntity != null ? destinationEntity : columns[0].getPropertyHolder().getPersistentClass();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving property " + associatedClass.getEntityName() + "." + columns[0].getMappedBy()));
            }
            Iterator mappedByColumns = (property = associatedClass.getProperty(columns[0].getMappedBy())).getValue() instanceof Collection ? ((Collection)property.getValue()).getElement().getColumnIterator() : property.getValue().getColumnIterator();
            while (mappedByColumns.hasNext()) {
                Column column = (Column)mappedByColumns.next();
                columns[0].linkValueUsingAColumnCopy(column, value);
            }
        } else if (columns[0].isImplicit()) {
            Iterator idColumns = referencedEntity.getIdentifier().getColumnIterator();
            while (idColumns.hasNext()) {
                Column column = (Column)idColumns.next();
                columns[0].linkValueUsingDefaultColumnNaming(column, value);
            }
        } else if (referencedEntity.getIdentifier().getColumnSpan() == 1) {
            if (columns.length != 1) {
                throw new AnnotationException("@JoinColumns with " + columns.length + " columns" + " refers to " + referencedEntity.getEntityName() + " which has a " + referencedEntity.getIdentifier().getColumnSpan() + " sized PK");
            }
            if (columns[0].isNameDeferred()) {
                Column idCol = (Column)referencedEntity.getIdentifier().getColumnIterator().next();
                columns[0].redefineColumnName(columns[0].getPropertyName() + "_" + idCol.getName());
            }
            columns[0].linkWithValue(value);
        } else {
            boolean noReferencedColumn = true;
            for (Ejb3JoinColumn joinCol : columns) {
                if (!StringHelper.isNotEmpty((String)joinCol.getReferencedColumn())) continue;
                noReferencedColumn = false;
                break;
            }
            if (noReferencedColumn) {
                if (columns.length != referencedEntity.getIdentifier().getColumnSpan()) {
                    throw new AnnotationException("A Foreign key refering " + referencedEntity.getEntityName() + " has the wrong number of column. should be " + referencedEntity.getIdentifier().getColumnSpan());
                }
                Iterator idColumns = referencedEntity.getIdentifier().getColumnIterator();
                for (Ejb3JoinColumn joinCol : columns) {
                    Column idCol = (Column)idColumns.next();
                    if (joinCol.isNameDeferred()) {
                        joinCol.redefineColumnName(joinCol.getPropertyName() + "_" + idCol.getName());
                    }
                    joinCol.linkWithValue(value);
                }
            } else {
                Iterator idColItr = referencedEntity.getIdentifier().getColumnIterator();
                if (!idColItr.hasNext()) {
                    log.debug((Object)"No column in the identifier!");
                }
                while (idColItr.hasNext()) {
                    boolean match = false;
                    Column col = (Column)idColItr.next();
                    for (Ejb3JoinColumn joinCol : columns) {
                        if (!joinCol.getReferencedColumn().equals(col.getName())) continue;
                        if (joinCol.isNameDeferred()) {
                            joinCol.redefineColumnName(joinCol.getPropertyName() + "_" + joinCol.getReferencedColumn());
                        }
                        joinCol.linkWithValue(value);
                        match = true;
                        break;
                    }
                    if (match) continue;
                    throw new AnnotationException("Column name " + col.getName() + " of " + referencedEntity.getEntityName() + " not found in JoinColumns.referencedColumnName");
                }
            }
        }
        value.createForeignKey();
        if (unique) {
            Iterator iter = value.getColumnIterator();
            ArrayList cols = new ArrayList();
            while (iter.hasNext()) {
                cols.add(iter.next());
            }
            value.getTable().createUniqueKey(cols);
        }
    }
}

