/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.OrderBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.ArrayBinder;
import org.hibernate.cfg.annotations.BagBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.ListBinder;
import org.hibernate.cfg.annotations.MapBinder;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.SetBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

public abstract class CollectionBinder {
    private static final Log log = LogFactory.getLog(CollectionBinder.class);
    protected org.hibernate.mapping.Collection collection;
    protected String propertyName;
    FetchMode fetchMode;
    PropertyHolder propertyHolder;
    int batchSize;
    String where;
    private String mappedBy;
    private Table table;
    private Class collectionType;
    private String targetEntity;
    private ExtendedMappings mappings;
    private boolean unique;
    private Ejb3JoinColumn[] inverseJoinColumns;
    private String cascadeStrategy;
    String cacheConcurrencyStrategy;
    Map<String, String> filters = new HashMap<String, String>();
    String cacheRegionName;
    private boolean oneToMany;
    protected IndexColumn indexColumn;
    private String orderBy;
    protected String hqlOrderBy;
    private boolean isSorted;
    private Class comparator;
    private boolean hasToBeSorted;
    protected boolean cascadeDeleteEnabled;
    protected String mapKeyPropertyName;
    private boolean insertable = true;
    private boolean updatable = true;
    private String propertyAccessorName;
    private Ejb3JoinColumn[] joinColumns;

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setCascadeStrategy(String cascadeStrategy) {
        this.cascadeStrategy = cascadeStrategy;
    }

    public void setPropertyAccessorName(String propertyAccessorName) {
        this.propertyAccessorName = propertyAccessorName;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setInverseJoinColumns(Ejb3JoinColumn[] inverseJoinColumns) {
        this.inverseJoinColumns = inverseJoinColumns;
    }

    public void setJoinColumns(Ejb3JoinColumn[] joinColumns) {
        this.joinColumns = joinColumns;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    public void setBatchSize(BatchSize batchSize) {
        this.batchSize = batchSize == null ? -1 : batchSize.size();
    }

    public void setEjb3OrderBy(OrderBy orderByAnn) {
        if (orderByAnn != null) {
            this.hqlOrderBy = orderByAnn.value();
        }
    }

    public void setSqlOrderBy(org.hibernate.annotations.OrderBy orderByAnn) {
        if (orderByAnn != null && !AnnotationBinder.isDefault(orderByAnn.clause())) {
            this.orderBy = orderByAnn.clause();
        }
    }

    public void setSort(Sort sortAnn) {
        if (sortAnn != null) {
            boolean bl = this.isSorted = !SortType.UNSORTED.equals((Object)sortAnn.type());
            if (this.isSorted && SortType.COMPARATOR.equals((Object)sortAnn.type())) {
                this.comparator = sortAnn.comparator();
            }
        }
    }

    public static CollectionBinder getCollectionBinder(String entityName, PropertyInferredData inferredData, boolean isIndexed) {
        CollectionBinder binder = null;
        Class returnedClass = inferredData.getReturnedClass();
        if (inferredData.isArray()) {
            binder = new ArrayBinder();
        } else if (Set.class.equals((Object)returnedClass)) {
            binder = new SetBinder();
        } else if (SortedSet.class.equals((Object)returnedClass)) {
            binder = new SetBinder(true);
        } else if (Map.class.equals((Object)returnedClass)) {
            binder = new MapBinder();
        } else if (Collection.class.equals((Object)returnedClass)) {
            binder = new BagBinder();
        } else if (List.class.equals((Object)returnedClass)) {
            binder = isIndexed ? new ListBinder() : new BagBinder();
        } else {
            throw new AnnotationException(returnedClass.getName() + " collection not yet supported: " + entityName + inferredData.getPropertyName());
        }
        return binder;
    }

    protected CollectionBinder() {
    }

    protected CollectionBinder(boolean sorted) {
        this.hasToBeSorted = sorted;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setCollectionType(Class collectionType) {
        this.collectionType = collectionType;
    }

    public void setTargetEntity(Class targetEntity) {
        this.targetEntity = AnnotationBinder.isDefault(targetEntity) ? "" : targetEntity.getName();
    }

    public void setMappings(ExtendedMappings mappings) {
        this.mappings = mappings;
    }

    protected abstract org.hibernate.mapping.Collection createCollection(PersistentClass var1);

    public org.hibernate.mapping.Collection getCollection() {
        return this.collection;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void bind() {
        if (log.isDebugEnabled()) {
            if (!this.oneToMany) {
                if (!this.unique) {
                    log.debug((Object)("Binding as ManyToMany: " + this.propertyHolder.getEntityName() + "." + this.propertyName));
                } else {
                    log.debug((Object)("Binding a OneToMany: " + this.propertyHolder.getEntityName() + "." + this.propertyName + " through an association table"));
                }
            } else {
                log.debug((Object)("Binding a OneToMany: " + this.propertyHolder.getEntityName() + "." + this.propertyName + " through a foreign key"));
            }
        }
        this.collection = this.createCollection(this.propertyHolder.getPersistentClass());
        log.debug((Object)("Collection role: " + StringHelper.qualify((String)this.propertyHolder.getPath(), (String)this.propertyName)));
        this.collection.setRole(StringHelper.qualify((String)this.propertyHolder.getPath(), (String)this.propertyName));
        this.collection.setFetchMode(this.fetchMode);
        this.collection.setLazy(this.fetchMode == FetchMode.SELECT);
        this.collection.setBatchSize(this.batchSize);
        if (this.orderBy != null && this.hqlOrderBy != null) {
            throw new AnnotationException("Cannot use sql order by clause in conjunction of EJB3 order by clause: " + this.safeCollectionRole());
        }
        if (this.orderBy != null) {
            this.collection.setOrderBy(this.orderBy);
        }
        if (this.isSorted) {
            this.collection.setSorted(true);
            if (this.comparator != null) {
                try {
                    this.collection.setComparator((Comparator)this.comparator.newInstance());
                }
                catch (Exception e) {
                    throw new AnnotationException("Could not instantiate comparator class: " + this.comparator.getName() + "(" + this.safeCollectionRole() + ")");
                }
            }
        } else if (this.hasToBeSorted) {
            throw new AnnotationException("A sorted collection has to define @Sort: " + this.safeCollectionRole());
        }
        if (StringHelper.isNotEmpty((String)this.cacheConcurrencyStrategy)) {
            this.collection.setCacheConcurrencyStrategy(this.cacheConcurrencyStrategy);
            this.collection.setCacheRegionName(this.cacheRegionName);
        }
        Iterator<Map.Entry<String, String>> iter = this.filters.entrySet().iterator();
        if (StringHelper.isNotEmpty((String)this.where)) {
            this.collection.setWhere(this.where);
        }
        while (iter.hasNext()) {
            Map.Entry<String, String> filter = iter.next();
            this.collection.addFilter(filter.getKey(), filter.getValue());
        }
        boolean isMappedBy = !AnnotationBinder.isDefault(this.mappedBy);
        this.collection.setInverse(isMappedBy);
        this.collection.setCollectionTable(this.table);
        String collType = this.getCollectionType();
        if (this.oneToMany) {
            OneToMany oneToMany = new OneToMany(this.collection.getOwner());
            this.collection.setElement((Value)oneToMany);
            oneToMany.setReferencedEntityName(collType);
        } else if (isMappedBy) {
            this.mappings.addMappedBy(collType, this.mappedBy, this.propertyName);
        }
        this.mappings.addSecondPass(this.getSecondPass(this.mappings, this.joinColumns, this.inverseJoinColumns, collType, this.fetchMode, this.unique), !isMappedBy);
        this.mappings.addCollection(this.collection);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(this.propertyName);
        binder.setValue((Value)this.collection);
        binder.setCascade(this.cascadeStrategy);
        binder.setPropertyAccessorName(this.propertyAccessorName);
        binder.setInsertable(this.insertable);
        binder.setUpdatable(this.updatable);
        Property prop = binder.make();
        this.propertyHolder.addProperty(prop);
    }

    private String getCollectionType() {
        if (AnnotationBinder.isDefault(this.targetEntity)) {
            if (this.collectionType != null) {
                return this.collectionType.getName();
            }
            String errorMsg = "Collection has neither generic type or OneToMany.targetEntity() defined: " + this.safeCollectionRole();
            throw new AnnotationException(errorMsg);
        }
        return this.targetEntity;
    }

    public SecondPass getSecondPass(ExtendedMappings mappings, final Ejb3JoinColumn[] keyColumns, final Ejb3JoinColumn[] inverseColumns, final String collType, final FetchMode fetchMode, final boolean unique) {
        if (inverseColumns != null) {
            return new SecondPass(mappings, this.collection){

                public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                    CollectionBinder.bindManyToManySecondPass(this.getCollection(), persistentClasses, keyColumns, inverseColumns, collType, fetchMode, unique, CollectionBinder.this.cascadeDeleteEnabled, (ExtendedMappings)this.getMappings());
                }
            };
        }
        return new SecondPass(mappings, this.collection){

            public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                CollectionBinder.bindCollectionSecondPass(this.getCollection(), persistentClasses, keyColumns, CollectionBinder.this.cascadeDeleteEnabled, CollectionBinder.this.hqlOrderBy, (ExtendedMappings)this.getMappings());
            }
        };
    }

    public void setCache(Cache cacheAnn) {
        if (cacheAnn != null) {
            this.cacheRegionName = AnnotationBinder.isDefault(cacheAnn.region()) ? null : cacheAnn.region();
            this.cacheConcurrencyStrategy = EntityBinder.getCacheConcurrencyStrategy(cacheAnn.usage());
        } else {
            this.cacheConcurrencyStrategy = null;
            this.cacheRegionName = null;
        }
    }

    public void setFetchType(FetchType fetch) {
        this.fetchMode = fetch == FetchType.EAGER ? FetchMode.JOIN : FetchMode.SELECT;
    }

    public void addFilter(String name, String condition) {
        this.filters.put(name, condition);
    }

    public void setWhere(Where whereAnn) {
        if (whereAnn != null) {
            this.where = whereAnn.clause();
        }
    }

    public void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public void setIndexColumn(IndexColumn indexColumn) {
        this.indexColumn = indexColumn;
    }

    public void setMapKey(MapKey key) {
        if (key != null) {
            this.mapKeyPropertyName = key.name();
        }
    }

    protected static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] columns, boolean cascadeDeleteEnabled, String hqlOrderBy, ExtendedMappings mappings) throws MappingException {
        if (collValue.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collValue.getElement();
            String assocClass = oneToMany.getReferencedEntityName();
            PersistentClass associatedClass = (PersistentClass)persistentClasses.get(assocClass);
            String orderBy = CollectionBinder.buildOrderByClauseFromHql(hqlOrderBy, associatedClass, collValue.getRole());
            if (orderBy != null) {
                collValue.setOrderBy(orderBy);
            }
            if (mappings == null) {
                throw new AssertionFailure("CollectionSecondPass for oneToMany should not be called with null mappings");
            }
            Map<String, Join> joins = mappings.getJoins(assocClass);
            if (associatedClass == null) {
                throw new MappingException("Association references unmapped class: " + assocClass);
            }
            oneToMany.setAssociatedClass(associatedClass);
            for (Ejb3JoinColumn column : columns) {
                column.setPersistentClass(associatedClass);
                column.setJoins(joins);
                collValue.setCollectionTable(column.getTable());
            }
            log.info((Object)("Mapping collection: " + collValue.getRole() + " -> " + collValue.getCollectionTable().getName()));
        }
        CollectionBinder.bindCollectionSecondPass(collValue, null, columns, cascadeDeleteEnabled);
        if (collValue.isOneToMany() && !collValue.isInverse() && !collValue.getKey().isNullable()) {
            String entityName = ((OneToMany)collValue.getElement()).getReferencedEntityName();
            PersistentClass referenced = mappings.getClass(entityName);
            Backref prop = new Backref();
            prop.setName('_' + columns[0].getPropertyName() + "Backref");
            prop.setUpdateable(false);
            prop.setSelectable(false);
            prop.setCollectionRole(collValue.getRole());
            prop.setEntityName(collValue.getOwner().getEntityName());
            prop.setValue((Value)collValue.getKey());
            referenced.addProperty((Property)prop);
        }
    }

    private static String buildOrderByClauseFromHql(String hqlOrderBy, PersistentClass associatedClass, String role) {
        String orderByString = null;
        if (hqlOrderBy != null) {
            ArrayList<String> properties = new ArrayList<String>();
            ArrayList<String> ordering = new ArrayList<String>();
            StringBuffer orderByBuffer = new StringBuffer();
            if ("".equals(hqlOrderBy)) {
                Iterator it = associatedClass.getIdentifier().getColumnIterator();
                while (it.hasNext()) {
                    Column col = (Column)it.next();
                    orderByBuffer.append(col.getName()).append(" asc").append(", ");
                }
            } else {
                StringTokenizer st = new StringTokenizer(hqlOrderBy, " ,", false);
                String currentOrdering = null;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (CollectionBinder.isNonPropertyToken(token)) {
                        if (currentOrdering != null) {
                            throw new AnnotationException("Error while parsing HQL orderBy clause: " + hqlOrderBy + " (" + role + ")");
                        }
                        currentOrdering = token;
                        continue;
                    }
                    if (currentOrdering == null) {
                        ordering.add("asc");
                    } else {
                        ordering.add(currentOrdering);
                        currentOrdering = null;
                    }
                    properties.add(token);
                }
                ordering.remove(0);
                if (currentOrdering == null) {
                    ordering.add("asc");
                } else {
                    ordering.add(currentOrdering);
                    currentOrdering = null;
                }
                int index = 0;
                for (String property : properties) {
                    Property p;
                    try {
                        p = associatedClass.getProperty(property);
                    }
                    catch (MappingException e) {
                        throw new AnnotationException("property from @OrderBy clause not found: " + associatedClass.getEntityName() + "." + property, e);
                    }
                    Iterator propertyColumns = p.getColumnIterator();
                    while (propertyColumns.hasNext()) {
                        Column column = (Column)propertyColumns.next();
                        orderByBuffer.append(column.getName()).append(" ").append((String)ordering.get(index)).append(", ");
                    }
                    ++index;
                }
            }
            orderByString = orderByBuffer.substring(0, orderByBuffer.length() - 2);
        }
        return orderByString;
    }

    private static boolean isNonPropertyToken(String token) {
        if (" ".equals(token)) {
            return true;
        }
        if (",".equals(token)) {
            return true;
        }
        if (token.equalsIgnoreCase("desc")) {
            return true;
        }
        return token.equalsIgnoreCase("asc");
    }

    private static SimpleValue buildCollectionKey(org.hibernate.mapping.Collection collValue, Ejb3JoinColumn[] joinColumns, boolean cascadeDeleteEnabled) {
        String propRef = collValue.getReferencedPropertyName();
        KeyValue keyVal = propRef == null ? collValue.getOwner().getIdentifier() : (KeyValue)collValue.getOwner().getProperty(propRef).getValue();
        DependantValue key = new DependantValue(collValue.getCollectionTable(), keyVal);
        key.setTypeName(null);
        Ejb3JoinColumn.checkPropertyConsistency(joinColumns, collValue.getOwnerEntityName());
        key.setNullable(joinColumns.length == 0 ? true : joinColumns[0].isNullable());
        key.setUpdateable(joinColumns.length == 0 ? true : joinColumns[0].isUpdatable());
        key.setCascadeDeleteEnabled(cascadeDeleteEnabled);
        collValue.setKey((KeyValue)key);
        return key;
    }

    protected static void bindManyToManySecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] joinColumns, Ejb3JoinColumn[] inverseJoinColumns, String collType, FetchMode fetchMode, boolean unique, boolean cascadeDeleteEnabled, ExtendedMappings mappings) throws MappingException {
        boolean mappedBy;
        PersistentClass collectionEntity = (PersistentClass)persistentClasses.get(collType);
        if (collectionEntity == null) {
            throw new MappingException("Association references unmapped class: " + collType);
        }
        boolean bl = mappedBy = !AnnotationBinder.isDefault(joinColumns[0].getMappedBy());
        if (mappedBy) {
            Property otherSideProperty;
            try {
                otherSideProperty = collectionEntity.getProperty(joinColumns[0].getMappedBy());
            }
            catch (MappingException e) {
                throw new AnnotationException("mappedBy reference an unknown property: " + collType + "." + joinColumns[0].getMappedBy());
            }
            Table table = ((org.hibernate.mapping.Collection)otherSideProperty.getValue()).getCollectionTable();
            collValue.setCollectionTable(table);
            for (Ejb3JoinColumn column : joinColumns) {
                column.setDefaultColumnHeader(joinColumns[0].getMappedBy());
            }
        } else {
            for (Ejb3JoinColumn column : joinColumns) {
                String header = mappings.getFromMappedBy(collValue.getOwnerEntityName(), column.getPropertyName());
                header = header == null ? collValue.getOwner().getTable().getName() : header;
                column.setDefaultColumnHeader(header);
            }
            if (collValue.getCollectionTable() == null) {
                String tableName = collValue.getOwner().getTable().getName() + "_" + collectionEntity.getTable().getName();
                Table table = TableBinder.fillTable("", "", tableName, false, new ArrayList(), null, null, mappings);
                collValue.setCollectionTable(table);
            }
        }
        CollectionBinder.bindCollectionSecondPass(collValue, collectionEntity, joinColumns, cascadeDeleteEnabled);
        ManyToOne element = new ManyToOne(collValue.getCollectionTable());
        collValue.setElement((Value)element);
        element.setReferencedEntityName(collType);
        element.setFetchMode(fetchMode);
        element.setLazy(fetchMode != FetchMode.JOIN);
        if ((collValue.getFilterMap().size() != 0 || StringHelper.isNotEmpty((String)collValue.getWhere())) && collValue.getFetchMode() == FetchMode.JOIN && collValue.getElement().getFetchMode() != FetchMode.JOIN) {
            throw new MappingException("@ManyToMany defining filter or where without join fetching not valid within collection using join fetching[" + collValue.getRole() + "]");
        }
        if (collectionEntity == null) {
            throw new MappingException("Association references unmapped class: " + collType);
        }
        TableBinder.bindManytoManyInverseFk(collectionEntity, inverseJoinColumns, (SimpleValue)element, unique);
    }

    private static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, PersistentClass collectionEntity, Ejb3JoinColumn[] joinColumns, boolean cascadeDeleteEnabled) {
        SimpleValue key = CollectionBinder.buildCollectionKey(collValue, joinColumns, cascadeDeleteEnabled);
        TableBinder.bindFk(collValue.getOwner(), collectionEntity, joinColumns, key, false);
    }

    public void setCascadeDeleteEnabled(boolean onDeleteCascade) {
        this.cascadeDeleteEnabled = onDeleteCascade;
    }

    private String safeCollectionRole() {
        if (this.propertyHolder != null) {
            return this.propertyHolder.getEntityName() + "." + this.propertyName;
        }
        return "";
    }
}

