/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.Entity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedMappings
extends Mappings {
    private static final Log log = LogFactory.getLog(ExtendedMappings.class);
    private final Map<String, IdGenerator> namedGenerators;
    private final Map<String, Map<String, Join>> joins;
    private final Map<Class, AnnotatedClassType> classTypes;
    private final Map<String, Properties> generatorTables;
    private final Map<Table, List<String[]>> tableUniqueConstraints;
    private final Map<String, String> mappedByResolver;

    ExtendedMappings(Map classes, Map collections, Map tables, Map queries, Map sqlqueries, Map sqlResultSetMappings, Map imports, List secondPasses, List propertyReferences, NamingStrategy namingStrategy, Map typeDefs, Map filterDefinitions, Map namedGenerators, Map<String, Map<String, Join>> joins, Map<Class, AnnotatedClassType> classTypes, Map extendsQueue, Map<String, Properties> generatorTables, Map<Table, List<String[]>> tableUniqueConstraints, Map<String, String> mappedByResolver) {
        super(classes, collections, tables, queries, sqlqueries, sqlResultSetMappings, imports, secondPasses, propertyReferences, namingStrategy, typeDefs, filterDefinitions, extendsQueue);
        this.namedGenerators = namedGenerators;
        this.joins = joins;
        this.classTypes = classTypes;
        this.generatorTables = generatorTables;
        this.tableUniqueConstraints = tableUniqueConstraints;
        this.mappedByResolver = mappedByResolver;
    }

    public void addGenerator(IdGenerator generator) throws MappingException {
        IdGenerator old = this.namedGenerators.put(generator.getName(), generator);
        if (old != null) {
            log.warn((Object)("duplicate generator name: " + generator.getName()));
        }
    }

    public void addJoins(PersistentClass persistentClass, Map<String, Join> joins) throws MappingException {
        Map<String, Join> old = this.joins.put(persistentClass.getEntityName(), joins);
        if (old != null) {
            log.warn((Object)("duplicate joins for class: " + persistentClass.getEntityName()));
        }
    }

    public AnnotatedClassType addClassType(Class clazz) {
        AnnotatedClassType type = clazz.isAnnotationPresent(Entity.class) ? AnnotatedClassType.ENTITY : (clazz.isAnnotationPresent(Embeddable.class) ? AnnotatedClassType.EMBEDDABLE : (clazz.isAnnotationPresent(EmbeddableSuperclass.class) ? AnnotatedClassType.EMBEDDABLE_SUPERCLASS : AnnotatedClassType.NONE));
        this.classTypes.put(clazz, type);
        return type;
    }

    public AnnotatedClassType getClassType(Class clazz) {
        AnnotatedClassType type = this.classTypes.get(clazz);
        if (type == null) {
            return this.addClassType(clazz);
        }
        return type;
    }

    public IdGenerator getGenerator(String name) {
        return this.getGenerator(name, null);
    }

    public Map<String, Join> getJoins(String persistentClass) {
        return this.joins.get(persistentClass);
    }

    public IdGenerator getGenerator(String name, Map<String, IdGenerator> localGenerators) {
        IdGenerator result;
        if (localGenerators != null && (result = localGenerators.get(name)) != null) {
            return result;
        }
        return this.namedGenerators.get(name);
    }

    public void addGeneratorTable(String name, Properties params) {
        Properties old = this.generatorTables.put(name, params);
        if (old != null) {
            log.warn((Object)("duplicate generator table: " + name));
        }
    }

    public Properties getGeneratorTableProperties(String name, Map<String, Properties> localGeneratorTables) {
        Properties result;
        if (localGeneratorTables != null && (result = localGeneratorTables.get(name)) != null) {
            return result;
        }
        return this.generatorTables.get(name);
    }

    public void addUniqueConstraints(Table table, List uniqueConstraints) {
        List<String[]> oldConstraints = this.tableUniqueConstraints.get(table);
        if (oldConstraints == null) {
            oldConstraints = new ArrayList<String[]>();
            this.tableUniqueConstraints.put(table, oldConstraints);
        }
        oldConstraints.addAll(uniqueConstraints);
    }

    public Map<Table, List<String[]>> getTableUniqueConstraints() {
        return this.tableUniqueConstraints;
    }

    public void addMappedBy(String entityName, String propertyName, String inversePropertyName) {
        this.mappedByResolver.put(entityName + "." + propertyName, inversePropertyName);
    }

    public String getFromMappedBy(String entityName, String propertyName) {
        return this.mappedByResolver.get(entityName + "." + propertyName);
    }
}

