/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPropertyHolder
implements PropertyHolder {
    private PersistentClass persistentClass;
    private Map<String, Column[]> columnOverride;

    public ClassPropertyHolder(PersistentClass persistentClass, Map<String, Column[]> columnOverride) {
        this.persistentClass = persistentClass;
        this.columnOverride = columnOverride;
    }

    @Override
    public String getPath() {
        return this.persistentClass.getEntityName();
    }

    @Override
    public Column[] getOverriddenColumn(String propertyName) {
        return this.columnOverride.get(propertyName);
    }

    @Override
    public Map<String, Column[]> mergeOverridenColumns(Map<String, Column[]> localColumnOverride) {
        HashMap<String, Column[]> merge = new HashMap<String, Column[]>(localColumnOverride);
        merge.putAll(localColumnOverride);
        return merge;
    }

    @Override
    public String getEntityName() {
        return this.persistentClass.getEntityName();
    }

    @Override
    public void addProperty(Property prop) {
        this.persistentClass.addProperty(prop);
    }

    @Override
    public String getClassName() {
        return this.persistentClass.getClassName();
    }

    @Override
    public Table getTable() {
        return this.persistentClass.getTable();
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public KeyValue getIdentifier() {
        return this.persistentClass.getIdentifier();
    }
}

